// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the user's namespace. Set this to aws to get the public namespace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`
}

// String returns the string representation
func (s DescribeNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the namespace.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The version of the user's namespace to describe.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The name of the public namespace that the latest namespace version is tracking.
	TrackingNamespaceName *string `locationName:"trackingNamespaceName" type:"string"`

	// The version of the public namespace that the latest version is tracking.
	TrackingNamespaceVersion *int64 `locationName:"trackingNamespaceVersion" type:"long"`
}

// String returns the string representation
func (s DescribeNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNamespace = "DescribeNamespace"

// DescribeNamespaceRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Gets the latest version of the user's namespace and the public version that
// it is tracking.
//
//    // Example sending a request using DescribeNamespaceRequest.
//    req := client.DescribeNamespaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace
func (c *Client) DescribeNamespaceRequest(input *DescribeNamespaceInput) DescribeNamespaceRequest {
	op := &aws.Operation{
		Name:       opDescribeNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNamespaceInput{}
	}

	req := c.newRequest(op, input, &DescribeNamespaceOutput{})

	return DescribeNamespaceRequest{Request: req, Input: input, Copy: c.DescribeNamespaceRequest}
}

// DescribeNamespaceRequest is the request type for the
// DescribeNamespace API operation.
type DescribeNamespaceRequest struct {
	*aws.Request
	Input *DescribeNamespaceInput
	Copy  func(*DescribeNamespaceInput) DescribeNamespaceRequest
}

// Send marshals and sends the DescribeNamespace API request.
func (r DescribeNamespaceRequest) Send(ctx context.Context) (*DescribeNamespaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNamespaceResponse{
		DescribeNamespaceOutput: r.Request.Data.(*DescribeNamespaceOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNamespaceResponse is the response type for the
// DescribeNamespace API operation.
type DescribeNamespaceResponse struct {
	*DescribeNamespaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNamespace request.
func (r *DescribeNamespaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
