// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateEntityToThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device to be associated with the thing.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" type:"string" required:"true"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The name of the thing to which the entity is to be associated.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateEntityToThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEntityToThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateEntityToThingInput"}

	if s.EntityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityId"))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateEntityToThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateEntityToThingOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateEntityToThing = "AssociateEntityToThing"

// AssociateEntityToThingRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Associates a device with a concrete thing that is in the user's registry.
//
// A thing can be associated with only one device at a time. If you associate
// a thing with a new device id, its previous association will be removed.
//
//    // Example sending a request using AssociateEntityToThingRequest.
//    req := client.AssociateEntityToThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing
func (c *Client) AssociateEntityToThingRequest(input *AssociateEntityToThingInput) AssociateEntityToThingRequest {
	op := &aws.Operation{
		Name:       opAssociateEntityToThing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateEntityToThingInput{}
	}

	req := c.newRequest(op, input, &AssociateEntityToThingOutput{})

	return AssociateEntityToThingRequest{Request: req, Input: input, Copy: c.AssociateEntityToThingRequest}
}

// AssociateEntityToThingRequest is the request type for the
// AssociateEntityToThing API operation.
type AssociateEntityToThingRequest struct {
	*aws.Request
	Input *AssociateEntityToThingInput
	Copy  func(*AssociateEntityToThingInput) AssociateEntityToThingRequest
}

// Send marshals and sends the AssociateEntityToThing API request.
func (r AssociateEntityToThingRequest) Send(ctx context.Context) (*AssociateEntityToThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateEntityToThingResponse{
		AssociateEntityToThingOutput: r.Request.Data.(*AssociateEntityToThingOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateEntityToThingResponse is the response type for the
// AssociateEntityToThing API operation.
type AssociateEntityToThingResponse struct {
	*AssociateEntityToThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateEntityToThing request.
func (r *AssociateEntityToThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
