// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The updated hierarchy definitions of the asset model. Each hierarchy specifies
	// an asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelHierarchies []AssetModelHierarchy `locationName:"assetModelHierarchies" type:"list"`

	// The ID of the asset model to update.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The updated property definitions of the asset model. For more information,
	// see Asset Properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelProperties []AssetModelProperty `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelDescription", 1))
	}

	if s.AssetModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelId", 36))
	}

	if s.AssetModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAssetModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetModelDescription != nil {
		v := *s.AssetModelDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelHierarchies != nil {
		v := s.AssetModelHierarchies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetModelHierarchies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AssetModelName != nil {
		v := *s.AssetModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelProperties != nil {
		v := s.AssetModelProperties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetModelProperties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset model, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAssetModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetModelStatus != nil {
		v := s.AssetModelStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assetModelStatus", v, metadata)
	}
	return nil
}

const opUpdateAssetModel = "UpdateAssetModel"

// UpdateAssetModelRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Updates an asset model and all of the assets that were created from the model.
// Each asset created from the model inherits the updated asset model's property
// and hierarchy definitions. For more information, see Updating Assets and
// Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// This operation overwrites the existing model with the provided model. To
// avoid deleting your asset model's properties or hierarchies, you must include
// their IDs and definitions in the updated asset model payload. For more information,
// see DescribeAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html).
//
// If you remove a property from an asset model or update a property's formula
// expression, AWS IoT SiteWise deletes all previous data for that property.
// If you remove a hierarchy definition from an asset model, AWS IoT SiteWise
// disassociates every asset associated with that hierarchy. You can't change
// the type or data type of an existing property.
//
//    // Example sending a request using UpdateAssetModelRequest.
//    req := client.UpdateAssetModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel
func (c *Client) UpdateAssetModelRequest(input *UpdateAssetModelInput) UpdateAssetModelRequest {
	op := &aws.Operation{
		Name:       opUpdateAssetModel,
		HTTPMethod: "PUT",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &UpdateAssetModelInput{}
	}

	req := c.newRequest(op, input, &UpdateAssetModelOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return UpdateAssetModelRequest{Request: req, Input: input, Copy: c.UpdateAssetModelRequest}
}

// UpdateAssetModelRequest is the request type for the
// UpdateAssetModel API operation.
type UpdateAssetModelRequest struct {
	*aws.Request
	Input *UpdateAssetModelInput
	Copy  func(*UpdateAssetModelInput) UpdateAssetModelRequest
}

// Send marshals and sends the UpdateAssetModel API request.
func (r UpdateAssetModelRequest) Send(ctx context.Context) (*UpdateAssetModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAssetModelResponse{
		UpdateAssetModelOutput: r.Request.Data.(*UpdateAssetModelOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAssetModelResponse is the response type for the
// UpdateAssetModel API operation.
type UpdateAssetModelResponse struct {
	*UpdateAssetModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAssetModel request.
func (r *UpdateAssetModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
