// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAssetPropertyAggregatesInput struct {
	_ struct{} `type:"structure"`

	// The data aggregating function.
	//
	// AggregateTypes is a required field
	AggregateTypes []AggregateType `location:"querystring" locationName:"aggregateTypes" min:"1" type:"list" required:"true"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []Quality `location:"querystring" locationName:"qualities" min:"1" type:"list"`

	// The time interval over which to aggregate data.
	//
	// Resolution is a required field
	Resolution *string `location:"querystring" locationName:"resolution" min:"2" type:"string" required:"true"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp" required:"true"`

	// The chronological sorting order of the requested information.
	TimeOrdering TimeOrdering `location:"querystring" locationName:"timeOrdering" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetAssetPropertyAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyAggregatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAssetPropertyAggregatesInput"}

	if s.AggregateTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("AggregateTypes"))
	}
	if s.AggregateTypes != nil && len(s.AggregateTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AggregateTypes", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}

	if s.EndDate == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndDate"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualities", 1))
	}

	if s.Resolution == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resolution"))
	}
	if s.Resolution != nil && len(*s.Resolution) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Resolution", 2))
	}

	if s.StartDate == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssetPropertyAggregatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AggregateTypes != nil {
		v := s.AggregateTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "aggregateTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndDate != nil {
		v := *s.EndDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyAlias != nil {
		v := *s.PropertyAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "propertyAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyId != nil {
		v := *s.PropertyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "propertyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualities != nil {
		v := s.Qualities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "qualities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Resolution != nil {
		v := *s.Resolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "resolution", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if len(s.TimeOrdering) > 0 {
		v := s.TimeOrdering

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "timeOrdering", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type GetAssetPropertyAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The requested aggregated values.
	//
	// AggregatedValues is a required field
	AggregatedValues []AggregatedValue `locationName:"aggregatedValues" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetAssetPropertyAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssetPropertyAggregatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AggregatedValues != nil {
		v := s.AggregatedValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "aggregatedValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetAssetPropertyAggregates = "GetAssetPropertyAggregates"

// GetAssetPropertyAggregatesRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Gets aggregated values for an asset property. For more information, see Querying
// Aggregated Property Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
//    // Example sending a request using GetAssetPropertyAggregatesRequest.
//    req := client.GetAssetPropertyAggregatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates
func (c *Client) GetAssetPropertyAggregatesRequest(input *GetAssetPropertyAggregatesInput) GetAssetPropertyAggregatesRequest {
	op := &aws.Operation{
		Name:       opGetAssetPropertyAggregates,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/aggregates",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyAggregatesInput{}
	}

	req := c.newRequest(op, input, &GetAssetPropertyAggregatesOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return GetAssetPropertyAggregatesRequest{Request: req, Input: input, Copy: c.GetAssetPropertyAggregatesRequest}
}

// GetAssetPropertyAggregatesRequest is the request type for the
// GetAssetPropertyAggregates API operation.
type GetAssetPropertyAggregatesRequest struct {
	*aws.Request
	Input *GetAssetPropertyAggregatesInput
	Copy  func(*GetAssetPropertyAggregatesInput) GetAssetPropertyAggregatesRequest
}

// Send marshals and sends the GetAssetPropertyAggregates API request.
func (r GetAssetPropertyAggregatesRequest) Send(ctx context.Context) (*GetAssetPropertyAggregatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAssetPropertyAggregatesResponse{
		GetAssetPropertyAggregatesOutput: r.Request.Data.(*GetAssetPropertyAggregatesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetAssetPropertyAggregatesRequestPaginator returns a paginator for GetAssetPropertyAggregates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetAssetPropertyAggregatesRequest(input)
//   p := iotsitewise.NewGetAssetPropertyAggregatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetAssetPropertyAggregatesPaginator(req GetAssetPropertyAggregatesRequest) GetAssetPropertyAggregatesPaginator {
	return GetAssetPropertyAggregatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetAssetPropertyAggregatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetAssetPropertyAggregatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetAssetPropertyAggregatesPaginator struct {
	aws.Pager
}

func (p *GetAssetPropertyAggregatesPaginator) CurrentPage() *GetAssetPropertyAggregatesOutput {
	return p.Pager.CurrentPage().(*GetAssetPropertyAggregatesOutput)
}

// GetAssetPropertyAggregatesResponse is the response type for the
// GetAssetPropertyAggregates API operation.
type GetAssetPropertyAggregatesResponse struct {
	*GetAssetPropertyAggregatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAssetPropertyAggregates request.
func (r *GetAssetPropertyAggregatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
