// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set to delete.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDatasetInput"}

	if s.DatasetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDatasetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DatasetName != nil {
		v := *s.DatasetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "datasetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDatasetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Deletes the specified data set.
//
// You do not have to delete the content of the data set before you perform
// this operation.
//
//    // Example sending a request using DeleteDatasetRequest.
//    req := client.DeleteDatasetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDataset
func (c *Client) DeleteDatasetRequest(input *DeleteDatasetInput) DeleteDatasetRequest {
	op := &aws.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datasets/{datasetName}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	req := c.newRequest(op, input, &DeleteDatasetOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteDatasetRequest{Request: req, Input: input, Copy: c.DeleteDatasetRequest}
}

// DeleteDatasetRequest is the request type for the
// DeleteDataset API operation.
type DeleteDatasetRequest struct {
	*aws.Request
	Input *DeleteDatasetInput
	Copy  func(*DeleteDatasetInput) DeleteDatasetRequest
}

// Send marshals and sends the DeleteDataset API request.
func (r DeleteDatasetRequest) Send(ctx context.Context) (*DeleteDatasetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDatasetResponse{
		DeleteDatasetOutput: r.Request.Data.(*DeleteDatasetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDatasetResponse is the response type for the
// DeleteDataset API operation.
type DeleteDatasetResponse struct {
	*DeleteDatasetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDataset request.
func (r *DeleteDatasetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
