// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RegisterCrossAccountAccessRoleInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants Amazon Inspector access to AWS Services
	// needed to perform security assessments.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCrossAccountAccessRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterCrossAccountAccessRoleInput"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterCrossAccountAccessRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterCrossAccountAccessRole = "RegisterCrossAccountAccessRole"

// RegisterCrossAccountAccessRoleRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Registers the IAM role that grants Amazon Inspector access to AWS Services
// needed to perform security assessments.
//
//    // Example sending a request using RegisterCrossAccountAccessRoleRequest.
//    req := client.RegisterCrossAccountAccessRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole
func (c *Client) RegisterCrossAccountAccessRoleRequest(input *RegisterCrossAccountAccessRoleInput) RegisterCrossAccountAccessRoleRequest {
	op := &aws.Operation{
		Name:       opRegisterCrossAccountAccessRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterCrossAccountAccessRoleInput{}
	}

	req := c.newRequest(op, input, &RegisterCrossAccountAccessRoleOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RegisterCrossAccountAccessRoleRequest{Request: req, Input: input, Copy: c.RegisterCrossAccountAccessRoleRequest}
}

// RegisterCrossAccountAccessRoleRequest is the request type for the
// RegisterCrossAccountAccessRole API operation.
type RegisterCrossAccountAccessRoleRequest struct {
	*aws.Request
	Input *RegisterCrossAccountAccessRoleInput
	Copy  func(*RegisterCrossAccountAccessRoleInput) RegisterCrossAccountAccessRoleRequest
}

// Send marshals and sends the RegisterCrossAccountAccessRole API request.
func (r RegisterCrossAccountAccessRoleRequest) Send(ctx context.Context) (*RegisterCrossAccountAccessRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterCrossAccountAccessRoleResponse{
		RegisterCrossAccountAccessRoleOutput: r.Request.Data.(*RegisterCrossAccountAccessRoleOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterCrossAccountAccessRoleResponse is the response type for the
// RegisterCrossAccountAccessRole API operation.
type RegisterCrossAccountAccessRoleResponse struct {
	*RegisterCrossAccountAccessRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterCrossAccountAccessRole request.
func (r *RegisterCrossAccountAccessRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
