// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type EnableHealthServiceAccessForOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableHealthServiceAccessForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

type EnableHealthServiceAccessForOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableHealthServiceAccessForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableHealthServiceAccessForOrganization = "EnableHealthServiceAccessForOrganization"

// EnableHealthServiceAccessForOrganizationRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Calling this operation enables AWS Health to work with AWS Organizations.
// This applies a Service Linked Role (SLR) to the master account in the organization.
// To learn more about the steps in this process, visit enabling service access
// for AWS Health in AWS Organizations. To call this operation, you must sign
// in as an IAM user, assume an IAM role, or sign in as the root user (not recommended)
// in the organization's master account.
//
//    // Example sending a request using EnableHealthServiceAccessForOrganizationRequest.
//    req := client.EnableHealthServiceAccessForOrganizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EnableHealthServiceAccessForOrganization
func (c *Client) EnableHealthServiceAccessForOrganizationRequest(input *EnableHealthServiceAccessForOrganizationInput) EnableHealthServiceAccessForOrganizationRequest {
	op := &aws.Operation{
		Name:       opEnableHealthServiceAccessForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableHealthServiceAccessForOrganizationInput{}
	}

	req := c.newRequest(op, input, &EnableHealthServiceAccessForOrganizationOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return EnableHealthServiceAccessForOrganizationRequest{Request: req, Input: input, Copy: c.EnableHealthServiceAccessForOrganizationRequest}
}

// EnableHealthServiceAccessForOrganizationRequest is the request type for the
// EnableHealthServiceAccessForOrganization API operation.
type EnableHealthServiceAccessForOrganizationRequest struct {
	*aws.Request
	Input *EnableHealthServiceAccessForOrganizationInput
	Copy  func(*EnableHealthServiceAccessForOrganizationInput) EnableHealthServiceAccessForOrganizationRequest
}

// Send marshals and sends the EnableHealthServiceAccessForOrganization API request.
func (r EnableHealthServiceAccessForOrganizationRequest) Send(ctx context.Context) (*EnableHealthServiceAccessForOrganizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableHealthServiceAccessForOrganizationResponse{
		EnableHealthServiceAccessForOrganizationOutput: r.Request.Data.(*EnableHealthServiceAccessForOrganizationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableHealthServiceAccessForOrganizationResponse is the response type for the
// EnableHealthServiceAccessForOrganization API operation.
type EnableHealthServiceAccessForOrganizationResponse struct {
	*EnableHealthServiceAccessForOrganizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableHealthServiceAccessForOrganization request.
func (r *EnableHealthServiceAccessForOrganizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
