// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAffectedAccountsForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the event. Format: arn:aws:health:event-region::event/SERVICE/EVENT_TYPE_CODE/EVENT_TYPE_PLUS_ID
	// . Example: Example: arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456
	//
	// EventArn is a required field
	EventArn *string `locationName:"eventArn" type:"string" required:"true"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedAccountsForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAffectedAccountsForOrganizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAffectedAccountsForOrganizationInput"}

	if s.EventArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAffectedAccountsForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A JSON set of elements of the affected accounts.
	AffectedAccounts []string `locationName:"affectedAccounts" type:"list"`

	EventScopeCode EventScopeCode `locationName:"eventScopeCode" type:"string" enum:"true"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedAccountsForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAffectedAccountsForOrganization = "DescribeAffectedAccountsForOrganization"

// DescribeAffectedAccountsForOrganizationRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns a list of accounts in the organization from AWS Organizations that
// are affected by the provided event.
//
// Before you can call this operation, you must first enable AWS Health to work
// with AWS Organizations. To do this, call the EnableHealthServiceAccessForOrganization
// operation from your organization's master account.
//
//    // Example sending a request using DescribeAffectedAccountsForOrganizationRequest.
//    req := client.DescribeAffectedAccountsForOrganizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedAccountsForOrganization
func (c *Client) DescribeAffectedAccountsForOrganizationRequest(input *DescribeAffectedAccountsForOrganizationInput) DescribeAffectedAccountsForOrganizationRequest {
	op := &aws.Operation{
		Name:       opDescribeAffectedAccountsForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAffectedAccountsForOrganizationInput{}
	}

	req := c.newRequest(op, input, &DescribeAffectedAccountsForOrganizationOutput{})

	return DescribeAffectedAccountsForOrganizationRequest{Request: req, Input: input, Copy: c.DescribeAffectedAccountsForOrganizationRequest}
}

// DescribeAffectedAccountsForOrganizationRequest is the request type for the
// DescribeAffectedAccountsForOrganization API operation.
type DescribeAffectedAccountsForOrganizationRequest struct {
	*aws.Request
	Input *DescribeAffectedAccountsForOrganizationInput
	Copy  func(*DescribeAffectedAccountsForOrganizationInput) DescribeAffectedAccountsForOrganizationRequest
}

// Send marshals and sends the DescribeAffectedAccountsForOrganization API request.
func (r DescribeAffectedAccountsForOrganizationRequest) Send(ctx context.Context) (*DescribeAffectedAccountsForOrganizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAffectedAccountsForOrganizationResponse{
		DescribeAffectedAccountsForOrganizationOutput: r.Request.Data.(*DescribeAffectedAccountsForOrganizationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAffectedAccountsForOrganizationRequestPaginator returns a paginator for DescribeAffectedAccountsForOrganization.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAffectedAccountsForOrganizationRequest(input)
//   p := health.NewDescribeAffectedAccountsForOrganizationRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAffectedAccountsForOrganizationPaginator(req DescribeAffectedAccountsForOrganizationRequest) DescribeAffectedAccountsForOrganizationPaginator {
	return DescribeAffectedAccountsForOrganizationPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAffectedAccountsForOrganizationInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAffectedAccountsForOrganizationPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAffectedAccountsForOrganizationPaginator struct {
	aws.Pager
}

func (p *DescribeAffectedAccountsForOrganizationPaginator) CurrentPage() *DescribeAffectedAccountsForOrganizationOutput {
	return p.Pager.CurrentPage().(*DescribeAffectedAccountsForOrganizationOutput)
}

// DescribeAffectedAccountsForOrganizationResponse is the response type for the
// DescribeAffectedAccountsForOrganization API operation.
type DescribeAffectedAccountsForOrganizationResponse struct {
	*DescribeAffectedAccountsForOrganizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAffectedAccountsForOrganization request.
func (r *DescribeAffectedAccountsForOrganizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
