// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateFilterInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action FilterAction `locationName:"action" min:"1" type:"string" enum:"true"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the filter.
	Description *string `locationName:"description" type:"string"`

	// The unique ID of the detector of the GuardDuty account that you want to create
	// a filter for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Represents the criteria to be used in the filter for querying findings.
	//
	// You can only use the following attributes to query findings:
	//
	//    * accountId
	//
	//    * region
	//
	//    * confidence
	//
	//    * id
	//
	//    * resource.accessKeyDetails.accessKeyId
	//
	//    * resource.accessKeyDetails.principalId
	//
	//    * resource.accessKeyDetails.userName
	//
	//    * resource.accessKeyDetails.userType
	//
	//    * resource.instanceDetails.iamInstanceProfile.id
	//
	//    * resource.instanceDetails.imageId
	//
	//    * resource.instanceDetails.instanceId
	//
	//    * resource.instanceDetails.outpostArn
	//
	//    * resource.instanceDetails.networkInterfaces.ipv6Addresses
	//
	//    * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
	//
	//    * resource.instanceDetails.networkInterfaces.publicDnsName
	//
	//    * resource.instanceDetails.networkInterfaces.publicIp
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupId
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupName
	//
	//    * resource.instanceDetails.networkInterfaces.subnetId
	//
	//    * resource.instanceDetails.networkInterfaces.vpcId
	//
	//    * resource.instanceDetails.tags.key
	//
	//    * resource.instanceDetails.tags.value
	//
	//    * resource.resourceType
	//
	//    * service.action.actionType
	//
	//    * service.action.awsApiCallAction.api
	//
	//    * service.action.awsApiCallAction.callerType
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.city.cityName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.country.countryName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asn
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.awsApiCallAction.serviceName
	//
	//    * service.action.dnsRequestAction.domain
	//
	//    * service.action.networkConnectionAction.blocked
	//
	//    * service.action.networkConnectionAction.connectionDirection
	//
	//    * service.action.networkConnectionAction.localPortDetails.port
	//
	//    * service.action.networkConnectionAction.protocol
	//
	//    * service.action.networkConnectionAction.localIpDetails.ipAddressV4
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.city.cityName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.country.countryName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asn
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.networkConnectionAction.remotePortDetails.port
	//
	//    * service.additionalInfo.threatListName
	//
	//    * service.archived When this attribute is set to TRUE, only archived findings
	//    are listed. When it's set to FALSE, only unarchived findings are listed.
	//    When this attribute is not set, all existing findings are listed.
	//
	//    * service.resourceRole
	//
	//    * severity
	//
	//    * type
	//
	//    * updatedAt Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
	//    YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.
	//
	// FindingCriteria is a required field
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure" required:"true"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank *int64 `locationName:"rank" min:"1" type:"integer"`

	// The tags to be added to a new filter resource.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFilterInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.FindingCriteria == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingCriteria"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}
	if s.Rank != nil && *s.Rank < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Rank", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Rank != nil {
		v := *s.Rank

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rank", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The name of the successfully created filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateFilter = "CreateFilter"

// CreateFilterRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Creates a filter using the specified finding criteria.
//
//    // Example sending a request using CreateFilterRequest.
//    req := client.CreateFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter
func (c *Client) CreateFilterRequest(input *CreateFilterInput) CreateFilterRequest {
	op := &aws.Operation{
		Name:       opCreateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/filter",
	}

	if input == nil {
		input = &CreateFilterInput{}
	}

	req := c.newRequest(op, input, &CreateFilterOutput{})

	return CreateFilterRequest{Request: req, Input: input, Copy: c.CreateFilterRequest}
}

// CreateFilterRequest is the request type for the
// CreateFilter API operation.
type CreateFilterRequest struct {
	*aws.Request
	Input *CreateFilterInput
	Copy  func(*CreateFilterInput) CreateFilterRequest
}

// Send marshals and sends the CreateFilter API request.
func (r CreateFilterRequest) Send(ctx context.Context) (*CreateFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFilterResponse{
		CreateFilterOutput: r.Request.Data.(*CreateFilterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFilterResponse is the response type for the
// CreateFilter API operation.
type CreateFilterResponse struct {
	*CreateFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFilter request.
func (r *CreateFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
