// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCoreDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCoreDefinitionInput"}

	if s.CoreDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCoreDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CoreDefinitionId != nil {
		v := *s.CoreDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "CoreDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCoreDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateCoreDefinition = "UpdateCoreDefinition"

// UpdateCoreDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Updates a core definition.
//
//    // Example sending a request using UpdateCoreDefinitionRequest.
//    req := client.UpdateCoreDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition
func (c *Client) UpdateCoreDefinitionRequest(input *UpdateCoreDefinitionInput) UpdateCoreDefinitionRequest {
	op := &aws.Operation{
		Name:       opUpdateCoreDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &UpdateCoreDefinitionInput{}
	}

	req := c.newRequest(op, input, &UpdateCoreDefinitionOutput{})

	return UpdateCoreDefinitionRequest{Request: req, Input: input, Copy: c.UpdateCoreDefinitionRequest}
}

// UpdateCoreDefinitionRequest is the request type for the
// UpdateCoreDefinition API operation.
type UpdateCoreDefinitionRequest struct {
	*aws.Request
	Input *UpdateCoreDefinitionInput
	Copy  func(*UpdateCoreDefinitionInput) UpdateCoreDefinitionRequest
}

// Send marshals and sends the UpdateCoreDefinition API request.
func (r UpdateCoreDefinitionRequest) Send(ctx context.Context) (*UpdateCoreDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCoreDefinitionResponse{
		UpdateCoreDefinitionOutput: r.Request.Data.(*UpdateCoreDefinitionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCoreDefinitionResponse is the response type for the
// UpdateCoreDefinition API operation.
type UpdateCoreDefinitionResponse struct {
	*UpdateCoreDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCoreDefinition request.
func (r *UpdateCoreDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
