// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListConnectorDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectorDefinitionVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListConnectorDefinitionVersionsInput"}

	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectorDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConnectorDefinitionVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConnectorDefinitionId != nil {
		v := *s.ConnectorDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectorDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListConnectorDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListConnectorDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConnectorDefinitionVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListConnectorDefinitionVersions = "ListConnectorDefinitionVersions"

// ListConnectorDefinitionVersionsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Lists the versions of a connector definition, which are containers for connectors.
// Connectors run on the Greengrass core and contain built-in integration with
// local infrastructure, device protocols, AWS, and other cloud services.
//
//    // Example sending a request using ListConnectorDefinitionVersionsRequest.
//    req := client.ListConnectorDefinitionVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions
func (c *Client) ListConnectorDefinitionVersionsRequest(input *ListConnectorDefinitionVersionsInput) ListConnectorDefinitionVersionsRequest {
	op := &aws.Operation{
		Name:       opListConnectorDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
	}

	if input == nil {
		input = &ListConnectorDefinitionVersionsInput{}
	}

	req := c.newRequest(op, input, &ListConnectorDefinitionVersionsOutput{})

	return ListConnectorDefinitionVersionsRequest{Request: req, Input: input, Copy: c.ListConnectorDefinitionVersionsRequest}
}

// ListConnectorDefinitionVersionsRequest is the request type for the
// ListConnectorDefinitionVersions API operation.
type ListConnectorDefinitionVersionsRequest struct {
	*aws.Request
	Input *ListConnectorDefinitionVersionsInput
	Copy  func(*ListConnectorDefinitionVersionsInput) ListConnectorDefinitionVersionsRequest
}

// Send marshals and sends the ListConnectorDefinitionVersions API request.
func (r ListConnectorDefinitionVersionsRequest) Send(ctx context.Context) (*ListConnectorDefinitionVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConnectorDefinitionVersionsResponse{
		ListConnectorDefinitionVersionsOutput: r.Request.Data.(*ListConnectorDefinitionVersionsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListConnectorDefinitionVersionsResponse is the response type for the
// ListConnectorDefinitionVersions API operation.
type ListConnectorDefinitionVersionsResponse struct {
	*ListConnectorDefinitionVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConnectorDefinitionVersions request.
func (r *ListConnectorDefinitionVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
