// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Defines an action to be initiated by a trigger.
type Action struct {
	_ struct{} `type:"structure"`

	// The job arguments used when this trigger fires. For this job run, they replace
	// the default arguments set in the job definition itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string `type:"map"`

	// The name of the crawler to be used with this action.
	CrawlerName *string `min:"1" type:"string"`

	// The name of a job to be executed.
	JobName *string `min:"1" type:"string"`

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The name of the SecurityConfiguration structure to be used with this action.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The
	// default is 2,880 minutes (48 hours). This overrides the timeout value set
	// in the parent job.
	Timeout *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Action"}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CrawlerName", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Records an error that occurred when attempting to stop a specified job run.
type BatchStopJobRunError struct {
	_ struct{} `type:"structure"`

	// Specifies details about the error that was encountered.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the job definition that is used in the job run in question.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run in question.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunError) String() string {
	return awsutil.Prettify(s)
}

// Records a successful request to stop a specified JobRun.
type BatchStopJobRunSuccessfulSubmission struct {
	_ struct{} `type:"structure"`

	// The name of the job definition used in the job run that was stopped.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run that was stopped.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunSuccessfulSubmission) String() string {
	return awsutil.Prettify(s)
}

// Defines a binary column statistics data.
type BinaryColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Average length of the column.
	//
	// AverageLength is a required field
	AverageLength *float64 `type:"double" required:"true"`

	// Maximum length of the column.
	//
	// MaximumLength is a required field
	MaximumLength *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s BinaryColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BinaryColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BinaryColumnStatisticsData"}

	if s.AverageLength == nil {
		invalidParams.Add(aws.NewErrParamRequired("AverageLength"))
	}

	if s.MaximumLength == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaximumLength"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a boolean column statistics.
type BooleanColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Number of false value.
	//
	// NumberOfFalses is a required field
	NumberOfFalses *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`

	// Number of true value.
	//
	// NumberOfTrues is a required field
	NumberOfTrues *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s BooleanColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BooleanColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BooleanColumnStatisticsData"}

	if s.NumberOfFalses == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfFalses"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if s.NumberOfTrues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfTrues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a table definition in the AWS Glue Data Catalog.
type CatalogEntry struct {
	_ struct{} `type:"structure"`

	// The database in which the table metadata resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table in question.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CatalogEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CatalogEntry"}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A structure containing migration status information.
type CatalogImportStatus struct {
	_ struct{} `type:"structure"`

	// True if the migration has completed, or False otherwise.
	ImportCompleted *bool `type:"boolean"`

	// The time that the migration was started.
	ImportTime *time.Time `type:"timestamp"`

	// The name of the person who initiated the migration.
	ImportedBy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CatalogImportStatus) String() string {
	return awsutil.Prettify(s)
}

// Specifies an AWS Glue Data Catalog target.
type CatalogTarget struct {
	_ struct{} `type:"structure"`

	// The name of the database to be synchronized.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of the tables to be synchronized.
	//
	// Tables is a required field
	Tables []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CatalogTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CatalogTarget"}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.Tables == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tables"))
	}
	if s.Tables != nil && len(s.Tables) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tables", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Classifiers are triggered during a crawl task. A classifier checks whether
// a given file is in a format it can handle. If it is, the classifier creates
// a schema in the form of a StructType object that matches that data format.
//
// You can use the standard classifiers that AWS Glue provides, or you can write
// your own classifiers to best categorize your data sources and specify the
// appropriate schemas to use for them. A classifier can be a grok classifier,
// an XML classifier, a JSON classifier, or a custom CSV classifier, as specified
// in one of the fields in the Classifier object.
type Classifier struct {
	_ struct{} `type:"structure"`

	// A classifier for comma-separated values (CSV).
	CsvClassifier *CsvClassifier `type:"structure"`

	// A classifier that uses grok.
	GrokClassifier *GrokClassifier `type:"structure"`

	// A classifier for JSON content.
	JsonClassifier *JsonClassifier `type:"structure"`

	// A classifier for XML content.
	XMLClassifier *XMLClassifier `type:"structure"`
}

// String returns the string representation
func (s Classifier) String() string {
	return awsutil.Prettify(s)
}

// Specifies how Amazon CloudWatch data should be encrypted.
type CloudWatchEncryption struct {
	_ struct{} `type:"structure"`

	// The encryption mode to use for CloudWatch data.
	CloudWatchEncryptionMode CloudWatchEncryptionMode `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchEncryption) String() string {
	return awsutil.Prettify(s)
}

// Represents a directional edge in a directed acyclic graph (DAG).
type CodeGenEdge struct {
	_ struct{} `type:"structure"`

	// The ID of the node at which the edge starts.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The ID of the node at which the edge ends.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`

	// The target of the edge.
	TargetParameter *string `type:"string"`
}

// String returns the string representation
func (s CodeGenEdge) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenEdge) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenEdge"}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Source", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a node in a directed acyclic graph (DAG)
type CodeGenNode struct {
	_ struct{} `type:"structure"`

	// Properties of the node, in the form of name-value pairs.
	//
	// Args is a required field
	Args []CodeGenNodeArg `type:"list" required:"true"`

	// A node identifier that is unique within the node's graph.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The line number of the node.
	LineNumber *int64 `type:"integer"`

	// The type of node that this is.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNode) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNode) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenNode"}

	if s.Args == nil {
		invalidParams.Add(aws.NewErrParamRequired("Args"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.NodeType == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeType"))
	}
	if s.Args != nil {
		for i, v := range s.Args {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Args", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An argument or property of a node.
type CodeGenNodeArg struct {
	_ struct{} `type:"structure"`

	// The name of the argument or property.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// True if the value is used as a parameter.
	Param *bool `type:"boolean"`

	// The value of the argument or property.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNodeArg) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNodeArg) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenNodeArg"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A column in a Table.
type Column struct {
	_ struct{} `type:"structure"`

	// A free-form text comment.
	Comment *string `type:"string"`

	// The name of the Column.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define properties associated with the column.
	Parameters map[string]string `type:"map"`

	// The data type of the Column.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Column) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Column"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a column containing error.
type ColumnError struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	ColumnName *string `min:"1" type:"string"`

	// The error message occurred during operation.
	Error *ErrorDetail `type:"structure"`
}

// String returns the string representation
func (s ColumnError) String() string {
	return awsutil.Prettify(s)
}

// Defines a column statistics.
type ColumnStatistics struct {
	_ struct{} `type:"structure"`

	// The analyzed time of the column statistics.
	//
	// AnalyzedTime is a required field
	AnalyzedTime *time.Time `type:"timestamp" required:"true"`

	// The name of the column.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The type of the column.
	//
	// ColumnType is a required field
	ColumnType *string `type:"string" required:"true"`

	// The statistics of the column.
	//
	// StatisticsData is a required field
	StatisticsData *ColumnStatisticsData `type:"structure" required:"true"`
}

// String returns the string representation
func (s ColumnStatistics) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnStatistics) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ColumnStatistics"}

	if s.AnalyzedTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzedTime"))
	}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}

	if s.ColumnType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnType"))
	}

	if s.StatisticsData == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatisticsData"))
	}
	if s.StatisticsData != nil {
		if err := s.StatisticsData.Validate(); err != nil {
			invalidParams.AddNested("StatisticsData", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a column statistics data.
type ColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Binary Column Statistics Data.
	BinaryColumnStatisticsData *BinaryColumnStatisticsData `type:"structure"`

	// Boolean Column Statistics Data.
	BooleanColumnStatisticsData *BooleanColumnStatisticsData `type:"structure"`

	// Date Column Statistics Data.
	DateColumnStatisticsData *DateColumnStatisticsData `type:"structure"`

	// Decimal Column Statistics Data.
	DecimalColumnStatisticsData *DecimalColumnStatisticsData `type:"structure"`

	// Double Column Statistics Data.
	DoubleColumnStatisticsData *DoubleColumnStatisticsData `type:"structure"`

	// Long Column Statistics Data.
	LongColumnStatisticsData *LongColumnStatisticsData `type:"structure"`

	// String Column Statistics Data.
	StringColumnStatisticsData *StringColumnStatisticsData `type:"structure"`

	// The name of the column.
	//
	// Type is a required field
	Type ColumnStatisticsType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ColumnStatisticsData"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.BinaryColumnStatisticsData != nil {
		if err := s.BinaryColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("BinaryColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.BooleanColumnStatisticsData != nil {
		if err := s.BooleanColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("BooleanColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.DateColumnStatisticsData != nil {
		if err := s.DateColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DateColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.DecimalColumnStatisticsData != nil {
		if err := s.DecimalColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DecimalColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.DoubleColumnStatisticsData != nil {
		if err := s.DoubleColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DoubleColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.LongColumnStatisticsData != nil {
		if err := s.LongColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("LongColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}
	if s.StringColumnStatisticsData != nil {
		if err := s.StringColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("StringColumnStatisticsData", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a column containing error.
type ColumnStatisticsError struct {
	_ struct{} `type:"structure"`

	// The ColumnStatistics of the column.
	ColumnStatistics *ColumnStatistics `type:"structure"`

	// The error message occurred during operation.
	Error *ErrorDetail `type:"structure"`
}

// String returns the string representation
func (s ColumnStatisticsError) String() string {
	return awsutil.Prettify(s)
}

// Defines a condition under which a trigger fires.
type Condition struct {
	_ struct{} `type:"structure"`

	// The state of the crawler to which this condition applies.
	CrawlState CrawlState `type:"string" enum:"true"`

	// The name of the crawler to which this condition applies.
	CrawlerName *string `min:"1" type:"string"`

	// The name of the job whose JobRuns this condition applies to, and on which
	// this trigger waits.
	JobName *string `min:"1" type:"string"`

	// A logical operator.
	LogicalOperator LogicalOperator `type:"string" enum:"true"`

	// The condition state. Currently, the only job states that a trigger can listen
	// for are SUCCEEDED, STOPPED, FAILED, and TIMEOUT. The only crawler states
	// that a trigger can listen for are SUCCEEDED, FAILED, and CANCELLED.
	State JobRunState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Condition"}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CrawlerName", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The confusion matrix shows you what your transform is predicting accurately
// and what types of errors it is making.
//
// For more information, see Confusion matrix (https://en.wikipedia.org/wiki/Confusion_matrix)
// in Wikipedia.
type ConfusionMatrix struct {
	_ struct{} `type:"structure"`

	// The number of matches in the data that the transform didn't find, in the
	// confusion matrix for your transform.
	NumFalseNegatives *int64 `type:"long"`

	// The number of nonmatches in the data that the transform incorrectly classified
	// as a match, in the confusion matrix for your transform.
	NumFalsePositives *int64 `type:"long"`

	// The number of nonmatches in the data that the transform correctly rejected,
	// in the confusion matrix for your transform.
	NumTrueNegatives *int64 `type:"long"`

	// The number of matches in the data that the transform correctly found, in
	// the confusion matrix for your transform.
	NumTruePositives *int64 `type:"long"`
}

// String returns the string representation
func (s ConfusionMatrix) String() string {
	return awsutil.Prettify(s)
}

// Defines a connection to a data source.
type Connection struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection:
	//
	//    * HOST - The host URI: either the fully qualified domain name (FQDN) or
	//    the IPv4 address of the database host.
	//
	//    * PORT - The port number, between 1024 and 65535, of the port on which
	//    the database host is listening for database connections.
	//
	//    * USER_NAME - The name under which to log in to the database. The value
	//    string for USER_NAME is "USERNAME".
	//
	//    * PASSWORD - A password, if one is used, for the user name.
	//
	//    * ENCRYPTED_PASSWORD - When you enable connection password protection
	//    by setting ConnectionPasswordEncryption in the Data Catalog encryption
	//    settings, this field stores the encrypted password.
	//
	//    * JDBC_DRIVER_JAR_URI - The Amazon Simple Storage Service (Amazon S3)
	//    path of the JAR file that contains the JDBC driver to use.
	//
	//    * JDBC_DRIVER_CLASS_NAME - The class name of the JDBC driver to use.
	//
	//    * JDBC_ENGINE - The name of the JDBC engine to use.
	//
	//    * JDBC_ENGINE_VERSION - The version of the JDBC engine to use.
	//
	//    * CONFIG_FILES - (Reserved for future use.)
	//
	//    * INSTANCE_ID - The instance ID to use.
	//
	//    * JDBC_CONNECTION_URL - The URL for connecting to a JDBC data source.
	//
	//    * JDBC_ENFORCE_SSL - A Boolean string (true, false) specifying whether
	//    Secure Sockets Layer (SSL) with hostname matching is enforced for the
	//    JDBC connection on the client. The default is false.
	//
	//    * CUSTOM_JDBC_CERT - An Amazon S3 location specifying the customer's root
	//    certificate. AWS Glue uses this root certificate to validate the customer’s
	//    certificate when connecting to the customer database. AWS Glue only handles
	//    X.509 certificates. The certificate provided must be DER-encoded and supplied
	//    in Base64 encoding PEM format.
	//
	//    * SKIP_CUSTOM_JDBC_CERT_VALIDATION - By default, this is false. AWS Glue
	//    validates the Signature algorithm and Subject Public Key Algorithm for
	//    the customer certificate. The only permitted algorithms for the Signature
	//    algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject
	//    Public Key Algorithm, the key length must be at least 2048. You can set
	//    the value of this property to true to skip AWS Glue’s validation of
	//    the customer certificate.
	//
	//    * CUSTOM_JDBC_CERT_STRING - A custom JDBC certificate string which is
	//    used for domain match or distinguished name match to prevent a man-in-the-middle
	//    attack. In Oracle database, this is used as the SSL_SERVER_CERT_DN; in
	//    Microsoft SQL Server, this is used as the hostNameInCertificate.
	//
	//    * CONNECTION_URL - The URL for connecting to a general (non-JDBC) data
	//    source.
	//
	//    * KAFKA_BOOTSTRAP_SERVERS - A comma-separated list of host and port pairs
	//    that are the addresses of the Apache Kafka brokers in a Kafka cluster
	//    to which a Kafka client will connect to and bootstrap itself.
	ConnectionProperties map[string]string `type:"map"`

	// The type of the connection. Currently, SFTP is not supported.
	ConnectionType ConnectionType `type:"string" enum:"true"`

	// The time that this connection definition was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the connection.
	Description *string `type:"string"`

	// The user, group, or role that last updated this connection definition.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The last time that this connection definition was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string `type:"list"`

	// The name of the connection definition.
	Name *string `min:"1" type:"string"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to make this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// A structure that is used to specify a connection to create or update.
type ConnectionInput struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection.
	//
	// ConnectionProperties is a required field
	ConnectionProperties map[string]string `type:"map" required:"true"`

	// The type of the connection. Currently, these types are supported:
	//
	//    * JDBC - Designates a connection to a database through Java Database Connectivity
	//    (JDBC).
	//
	//    * KAFKA - Designates a connection to an Apache Kafka streaming platform.
	//
	//    * MONGODB - Designates a connection to a MongoDB document database.
	//
	// SFTP is not supported.
	//
	// ConnectionType is a required field
	ConnectionType ConnectionType `type:"string" required:"true" enum:"true"`

	// The description of the connection.
	Description *string `type:"string"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string `type:"list"`

	// The name of the connection.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to successfully make this connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s ConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionInput"}

	if s.ConnectionProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionProperties"))
	}
	if len(s.ConnectionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.PhysicalConnectionRequirements != nil {
		if err := s.PhysicalConnectionRequirements.Validate(); err != nil {
			invalidParams.AddNested("PhysicalConnectionRequirements", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data structure used by the Data Catalog to encrypt the password as part
// of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD
// field in the connection properties. You can enable catalog encryption or
// only password encryption.
//
// When a CreationConnection request arrives containing a password, the Data
// Catalog first encrypts the password using your AWS KMS key. It then encrypts
// the whole connection object again if catalog encryption is also enabled.
//
// This encryption requires that you set AWS KMS key permissions to enable or
// restrict access on the password key according to your security requirements.
// For example, you might want only administrators to have decrypt permission
// on the password key.
type ConnectionPasswordEncryption struct {
	_ struct{} `type:"structure"`

	// An AWS KMS key that is used to encrypt the connection password.
	//
	// If connection password protection is enabled, the caller of CreateConnection
	// and UpdateConnection needs at least kms:Encrypt permission on the specified
	// AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
	//
	// You can set the decrypt permission to enable or restrict access on the password
	// key according to your security requirements.
	AwsKmsKeyId *string `min:"1" type:"string"`

	// When the ReturnConnectionPasswordEncrypted flag is set to "true", passwords
	// remain encrypted in the responses of GetConnection and GetConnections. This
	// encryption takes effect independently from catalog encryption.
	//
	// ReturnConnectionPasswordEncrypted is a required field
	ReturnConnectionPasswordEncrypted *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ConnectionPasswordEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionPasswordEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionPasswordEncryption"}
	if s.AwsKmsKeyId != nil && len(*s.AwsKmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsKmsKeyId", 1))
	}

	if s.ReturnConnectionPasswordEncrypted == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReturnConnectionPasswordEncrypted"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the connections used by a job.
type ConnectionsList struct {
	_ struct{} `type:"structure"`

	// A list of connections used by the job.
	Connections []string `type:"list"`
}

// String returns the string representation
func (s ConnectionsList) String() string {
	return awsutil.Prettify(s)
}

// The details of a crawl in the workflow.
type Crawl struct {
	_ struct{} `type:"structure"`

	// The date and time on which the crawl completed.
	CompletedOn *time.Time `type:"timestamp"`

	// The error message associated with the crawl.
	ErrorMessage *string `type:"string"`

	// The log group associated with the crawl.
	LogGroup *string `min:"1" type:"string"`

	// The log stream associated with the crawl.
	LogStream *string `min:"1" type:"string"`

	// The date and time on which the crawl started.
	StartedOn *time.Time `type:"timestamp"`

	// The state of the crawler.
	State CrawlState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Crawl) String() string {
	return awsutil.Prettify(s)
}

// Specifies a crawler program that examines a data source and uses classifiers
// to try to determine its schema. If successful, the crawler records metadata
// concerning the data source in the AWS Glue Data Catalog.
type Crawler struct {
	_ struct{} `type:"structure"`

	// A list of UTF-8 strings that specify the custom classifiers that are associated
	// with the crawler.
	Classifiers []string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a crawler's behavior. For more information, see Configuring
	// a Crawler (https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
	Configuration *string `type:"string"`

	// If the crawler is running, contains the total time elapsed since the last
	// crawl began.
	CrawlElapsedTime *int64 `type:"long"`

	// The name of the SecurityConfiguration structure to be used by this crawler.
	CrawlerSecurityConfiguration *string `type:"string"`

	// The time that the crawler was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the database in which the crawler's output is stored.
	DatabaseName *string `type:"string"`

	// A description of the crawler.
	Description *string `type:"string"`

	// The status of the last crawl, and potentially error information if an error
	// occurred.
	LastCrawl *LastCrawlInfo `type:"structure"`

	// The time that the crawler was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the crawler.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that's used to access customer
	// resources, such as Amazon Simple Storage Service (Amazon S3) data.
	Role *string `type:"string"`

	// For scheduled crawlers, the schedule when the crawler runs.
	Schedule *Schedule `type:"structure"`

	// The policy that specifies update and delete behaviors for the crawler.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// Indicates whether the crawler is running, or whether a run is pending.
	State CrawlerState `type:"string" enum:"true"`

	// The prefix added to the names of tables that are created.
	TablePrefix *string `type:"string"`

	// A collection of targets to crawl.
	Targets *CrawlerTargets `type:"structure"`

	// The version of the crawler.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s Crawler) String() string {
	return awsutil.Prettify(s)
}

// Metrics for a specified crawler.
type CrawlerMetrics struct {
	_ struct{} `type:"structure"`

	// The name of the crawler.
	CrawlerName *string `min:"1" type:"string"`

	// The duration of the crawler's most recent run, in seconds.
	LastRuntimeSeconds *float64 `type:"double"`

	// The median duration of this crawler's runs, in seconds.
	MedianRuntimeSeconds *float64 `type:"double"`

	// True if the crawler is still estimating how long it will take to complete
	// this run.
	StillEstimating *bool `type:"boolean"`

	// The number of tables created by this crawler.
	TablesCreated *int64 `type:"integer"`

	// The number of tables deleted by this crawler.
	TablesDeleted *int64 `type:"integer"`

	// The number of tables updated by this crawler.
	TablesUpdated *int64 `type:"integer"`

	// The estimated time left to complete a running crawl.
	TimeLeftSeconds *float64 `type:"double"`
}

// String returns the string representation
func (s CrawlerMetrics) String() string {
	return awsutil.Prettify(s)
}

// The details of a Crawler node present in the workflow.
type CrawlerNodeDetails struct {
	_ struct{} `type:"structure"`

	// A list of crawls represented by the crawl node.
	Crawls []Crawl `type:"list"`
}

// String returns the string representation
func (s CrawlerNodeDetails) String() string {
	return awsutil.Prettify(s)
}

// Specifies data stores to crawl.
type CrawlerTargets struct {
	_ struct{} `type:"structure"`

	// Specifies AWS Glue Data Catalog targets.
	CatalogTargets []CatalogTarget `type:"list"`

	// Specifies Amazon DynamoDB targets.
	DynamoDBTargets []DynamoDBTarget `type:"list"`

	// Specifies JDBC targets.
	JdbcTargets []JdbcTarget `type:"list"`

	// Specifies Amazon Simple Storage Service (Amazon S3) targets.
	S3Targets []S3Target `type:"list"`
}

// String returns the string representation
func (s CrawlerTargets) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrawlerTargets) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CrawlerTargets"}
	if s.CatalogTargets != nil {
		for i, v := range s.CatalogTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CatalogTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a custom CSV classifier for CreateClassifier to create.
type CreateCsvClassifierRequest struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// Must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCsvClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCsvClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCsvClassifierRequest"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Delimiter", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.QuoteSymbol != nil && len(*s.QuoteSymbol) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuoteSymbol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a grok classifier for CreateClassifier to create.
type CreateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The name of the new classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrokClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGrokClassifierRequest"}

	if s.Classification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Classification"))
	}

	if s.GrokPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("GrokPattern"))
	}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrokPattern", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a JSON classifier for CreateClassifier to create.
type CreateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJsonClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateJsonClassifierRequest"}

	if s.JsonPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("JsonPath"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an XML classifier for CreateClassifier to create.
type CreateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s CreateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateXMLClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateXMLClassifierRequest"}

	if s.Classification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Classification"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier for custom CSV content.
type CsvClassifier struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// It must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s CsvClassifier) String() string {
	return awsutil.Prettify(s)
}

// Contains configuration information for maintaining Data Catalog security.
type DataCatalogEncryptionSettings struct {
	_ struct{} `type:"structure"`

	// When connection password protection is enabled, the Data Catalog uses a customer-provided
	// key to encrypt the password as part of CreateConnection or UpdateConnection
	// and store it in the ENCRYPTED_PASSWORD field in the connection properties.
	// You can enable catalog encryption or only password encryption.
	ConnectionPasswordEncryption *ConnectionPasswordEncryption `type:"structure"`

	// Specifies the encryption-at-rest configuration for the Data Catalog.
	EncryptionAtRest *EncryptionAtRest `type:"structure"`
}

// String returns the string representation
func (s DataCatalogEncryptionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCatalogEncryptionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataCatalogEncryptionSettings"}
	if s.ConnectionPasswordEncryption != nil {
		if err := s.ConnectionPasswordEncryption.Validate(); err != nil {
			invalidParams.AddNested("ConnectionPasswordEncryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The AWS Lake Formation principal.
type DataLakePrincipal struct {
	_ struct{} `type:"structure"`

	// An identifier for the AWS Lake Formation principal.
	DataLakePrincipalIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DataLakePrincipal) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakePrincipal) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataLakePrincipal"}
	if s.DataLakePrincipalIdentifier != nil && len(*s.DataLakePrincipalIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataLakePrincipalIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Database object represents a logical grouping of tables that might reside
// in a Hive metastore or an RDBMS.
type Database struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string `min:"1" type:"string"`

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []PrincipalPermissions `type:"list"`

	// The time at which the metadata database was created in the catalog.
	CreateTime *time.Time `type:"timestamp"`

	// A description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]string `type:"map"`

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier `type:"structure"`
}

// String returns the string representation
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// A structure that describes a target database for resource linking.
type DatabaseIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database.
	DatabaseName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DatabaseIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatabaseIdentifier"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The structure used to create or update a database.
type DatabaseInput struct {
	_ struct{} `type:"structure"`

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []PrincipalPermissions `type:"list"`

	// A description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define parameters and properties of the database.
	//
	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]string `type:"map"`

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier `type:"structure"`
}

// String returns the string representation
func (s DatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatabaseInput"}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LocationUri", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.CreateTableDefaultPermissions != nil {
		for i, v := range s.CreateTableDefaultPermissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateTableDefaultPermissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TargetDatabase != nil {
		if err := s.TargetDatabase.Validate(); err != nil {
			invalidParams.AddNested("TargetDatabase", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a date column statistics data.
type DateColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Maximum value of the column.
	MaximumValue *time.Time `type:"timestamp"`

	// Minimum value of the column.
	MinimumValue *time.Time `type:"timestamp"`

	// Number of distinct values.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DateColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DateColumnStatisticsData"}

	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDistinctValues"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a decimal column statistics data.
type DecimalColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Maximum value of the column.
	MaximumValue *DecimalNumber `type:"structure"`

	// Minimum value of the column.
	MinimumValue *DecimalNumber `type:"structure"`

	// Number of distinct values.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DecimalColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecimalColumnStatisticsData"}

	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDistinctValues"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}
	if s.MaximumValue != nil {
		if err := s.MaximumValue.Validate(); err != nil {
			invalidParams.AddNested("MaximumValue", err.(aws.ErrInvalidParams))
		}
	}
	if s.MinimumValue != nil {
		if err := s.MinimumValue.Validate(); err != nil {
			invalidParams.AddNested("MinimumValue", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains a numeric value in decimal format.
type DecimalNumber struct {
	_ struct{} `type:"structure"`

	// The scale that determines where the decimal point falls in the unscaled value.
	//
	// Scale is a required field
	Scale *int64 `type:"integer" required:"true"`

	// The unscaled numeric value.
	//
	// UnscaledValue is automatically base64 encoded/decoded by the SDK.
	//
	// UnscaledValue is a required field
	UnscaledValue []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s DecimalNumber) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalNumber) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecimalNumber"}

	if s.Scale == nil {
		invalidParams.Add(aws.NewErrParamRequired("Scale"))
	}

	if s.UnscaledValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnscaledValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A development endpoint where a developer can remotely debug extract, transform,
// and load (ETL) scripts.
type DevEndpoint struct {
	_ struct{} `type:"structure"`

	// A map of arguments used to configure the DevEndpoint.
	//
	// Valid arguments are:
	//
	//    * "--enable-glue-datacatalog": ""
	//
	//    * "GLUE_PYTHON_VERSION": "3"
	//
	//    * "GLUE_PYTHON_VERSION": "2"
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	Arguments map[string]string `type:"map"`

	// The AWS Availability Zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name of the DevEndpoint.
	EndpointName *string `type:"string"`

	// The path to one or more Java .jar files in an S3 bucket that should be loaded
	// in your DevEndpoint.
	//
	// You can only use pure Java/Scala libraries with a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an Amazon S3 bucket that should
	// be loaded in your DevEndpoint. Multiple values must be complete paths separated
	// by a comma.
	//
	// You can only use pure Python libraries with a DevEndpoint. Libraries that
	// rely on C extensions, such as the pandas (http://pandas.pydata.org/) Python
	// data analysis library, are not currently supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for running
	// your ETL scripts on development endpoints.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Development endpoints that are created without specifying a Glue version
	// default to Glue 0.9.
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	GlueVersion *string `min:"1" type:"string"`

	// The point in time at which this DevEndpoint was last modified.
	LastModifiedTimestamp *time.Time `type:"timestamp"`

	// The status of the last update.
	LastUpdateStatus *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The number of workers of a defined workerType that are allocated to the development
	// endpoint.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// A private IP address to access the DevEndpoint within a VPC if the DevEndpoint
	// is created within one. The PrivateAddress field is present only when you
	// create the DevEndpoint within your VPC.
	PrivateAddress *string `type:"string"`

	// The public IP address used by this DevEndpoint. The PublicAddress field is
	// present only when you create a non-virtual private cloud (VPC) DevEndpoint.
	PublicAddress *string `type:"string"`

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility because the recommended attribute
	// to use is public keys.
	PublicKey *string `type:"string"`

	// A list of public keys to be used by the DevEndpoints for authentication.
	// Using this attribute is preferred over a single public key because the public
	// keys allow you to have a different private key per client.
	//
	// If you previously created an endpoint with a public key, you must remove
	// that key to be able to set a list of public keys. Call the UpdateDevEndpoint
	// API operation with the public key content in the deletePublicKeys attribute,
	// and the list of new keys in the addPublicKeys attribute.
	PublicKeys []string `type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role used in this DevEndpoint.
	RoleArn *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// A list of security group identifiers used in this DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The current status of this DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID for this DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The type of predefined worker that is allocated to the development endpoint.
	// Accepts a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	// Known issue: when a development endpoint is created with the G.2X WorkerType
	// configuration, the Spark drivers for the development endpoint will run on
	// 4 vCPU, 16 GB of memory, and a 64 GB disk.
	WorkerType WorkerType `type:"string" enum:"true"`

	// The YARN endpoint address used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s DevEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Custom libraries to be loaded into a development endpoint.
type DevEndpointCustomLibraries struct {
	_ struct{} `type:"structure"`

	// The path to one or more Java .jar files in an S3 bucket that should be loaded
	// in your DevEndpoint.
	//
	// You can only use pure Java/Scala libraries with a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an Amazon Simple Storage Service
	// (Amazon S3) bucket that should be loaded in your DevEndpoint. Multiple values
	// must be complete paths separated by a comma.
	//
	// You can only use pure Python libraries with a DevEndpoint. Libraries that
	// rely on C extensions, such as the pandas (http://pandas.pydata.org/) Python
	// data analysis library, are not currently supported.
	ExtraPythonLibsS3Path *string `type:"string"`
}

// String returns the string representation
func (s DevEndpointCustomLibraries) String() string {
	return awsutil.Prettify(s)
}

// Defines a double column statistics data.
type DoubleColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Maximum value of the column.
	MaximumValue *float64 `type:"double"`

	// Minimum value of the column.
	MinimumValue *float64 `type:"double"`

	// Number of distinct values.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DoubleColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DoubleColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DoubleColumnStatisticsData"}

	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDistinctValues"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an Amazon DynamoDB table to crawl.
type DynamoDBTarget struct {
	_ struct{} `type:"structure"`

	// The name of the DynamoDB table to crawl.
	Path *string `type:"string"`

	// Indicates whether to scan all the records, or to sample rows from the table.
	// Scanning all the records can take a long time when the table is not a high
	// throughput table.
	//
	// A value of true means to scan all records, while a value of false means to
	// sample the records. If no value is specified, the value defaults to true.
	ScanAll *bool `locationName:"scanAll" type:"boolean"`

	// The percentage of the configured read capacity units to use by the AWS Glue
	// crawler. Read capacity units is a term defined by DynamoDB, and is a numeric
	// value that acts as rate limiter for the number of reads that can be performed
	// on that table per second.
	//
	// The valid values are null or a value between 0.1 to 1.5. A null value is
	// used when user does not provide a value, and defaults to 0.5 of the configured
	// Read Capacity Unit (for provisioned tables), or 0.25 of the max configured
	// Read Capacity Unit (for tables using on-demand mode).
	ScanRate *float64 `locationName:"scanRate" type:"double"`
}

// String returns the string representation
func (s DynamoDBTarget) String() string {
	return awsutil.Prettify(s)
}

// An edge represents a directed connection between two AWS Glue components
// which are part of the workflow the edge belongs to.
type Edge struct {
	_ struct{} `type:"structure"`

	// The unique of the node within the workflow where the edge ends.
	DestinationId *string `min:"1" type:"string"`

	// The unique of the node within the workflow where the edge starts.
	SourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Edge) String() string {
	return awsutil.Prettify(s)
}

// Specifies the encryption-at-rest configuration for the Data Catalog.
type EncryptionAtRest struct {
	_ struct{} `type:"structure"`

	// The encryption-at-rest mode for encrypting Data Catalog data.
	//
	// CatalogEncryptionMode is a required field
	CatalogEncryptionMode CatalogEncryptionMode `type:"string" required:"true" enum:"true"`

	// The ID of the AWS KMS key to use for encryption at rest.
	SseAwsKmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptionAtRest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionAtRest"}
	if len(s.CatalogEncryptionMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CatalogEncryptionMode"))
	}
	if s.SseAwsKmsKeyId != nil && len(*s.SseAwsKmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SseAwsKmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an encryption configuration.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption configuration for Amazon CloudWatch.
	CloudWatchEncryption *CloudWatchEncryption `type:"structure"`

	// The encryption configuration for job bookmarks.
	JobBookmarksEncryption *JobBookmarksEncryption `type:"structure"`

	// The encryption configuration for Amazon Simple Storage Service (Amazon S3)
	// data.
	S3Encryption []S3Encryption `type:"list"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Contains details about an error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with this error.
	ErrorCode *string `min:"1" type:"string"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// Evaluation metrics provide an estimate of the quality of your machine learning
// transform.
type EvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// The evaluation metrics for the find matches algorithm.
	FindMatchesMetrics *FindMatchesMetrics `type:"structure"`

	// The type of machine learning transform.
	//
	// TransformType is a required field
	TransformType TransformType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// An execution property of a job.
type ExecutionProperty struct {
	_ struct{} `type:"structure"`

	// The maximum number of concurrent runs allowed for the job. The default is
	// 1. An error is returned when this threshold is reached. The maximum value
	// you can specify is controlled by a service limit.
	MaxConcurrentRuns *int64 `type:"integer"`
}

// String returns the string representation
func (s ExecutionProperty) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration properties for an exporting labels task run.
type ExportLabelsTaskRunProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Simple Storage Service (Amazon S3) path where you will export
	// the labels.
	OutputS3Path *string `type:"string"`
}

// String returns the string representation
func (s ExportLabelsTaskRunProperties) String() string {
	return awsutil.Prettify(s)
}

// The evaluation metrics for the find matches algorithm. The quality of your
// machine learning transform is measured by getting your transform to predict
// some matches and comparing the results to known matches from the same dataset.
// The quality metrics are based on a subset of your data, so they are not precise.
type FindMatchesMetrics struct {
	_ struct{} `type:"structure"`

	// The area under the precision/recall curve (AUPRC) is a single number measuring
	// the overall quality of the transform, that is independent of the choice made
	// for precision vs. recall. Higher values indicate that you have a more attractive
	// precision vs. recall tradeoff.
	//
	// For more information, see Precision and recall (https://en.wikipedia.org/wiki/Precision_and_recall)
	// in Wikipedia.
	AreaUnderPRCurve *float64 `type:"double"`

	// The confusion matrix shows you what your transform is predicting accurately
	// and what types of errors it is making.
	//
	// For more information, see Confusion matrix (https://en.wikipedia.org/wiki/Confusion_matrix)
	// in Wikipedia.
	ConfusionMatrix *ConfusionMatrix `type:"structure"`

	// The maximum F1 metric indicates the transform's accuracy between 0 and 1,
	// where 1 is the best accuracy.
	//
	// For more information, see F1 score (https://en.wikipedia.org/wiki/F1_score)
	// in Wikipedia.
	F1 *float64 `type:"double"`

	// The precision metric indicates when often your transform is correct when
	// it predicts a match. Specifically, it measures how well the transform finds
	// true positives from the total true positives possible.
	//
	// For more information, see Precision and recall (https://en.wikipedia.org/wiki/Precision_and_recall)
	// in Wikipedia.
	Precision *float64 `type:"double"`

	// The recall metric indicates that for an actual match, how often your transform
	// predicts the match. Specifically, it measures how well the transform finds
	// true positives from the total records in the source data.
	//
	// For more information, see Precision and recall (https://en.wikipedia.org/wiki/Precision_and_recall)
	// in Wikipedia.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s FindMatchesMetrics) String() string {
	return awsutil.Prettify(s)
}

// The parameters to configure the find matches transform.
type FindMatchesParameters struct {
	_ struct{} `type:"structure"`

	// The value that is selected when tuning your transform for a balance between
	// accuracy and cost. A value of 0.5 means that the system balances accuracy
	// and cost concerns. A value of 1.0 means a bias purely for accuracy, which
	// typically results in a higher cost, sometimes substantially higher. A value
	// of 0.0 means a bias purely for cost, which results in a less accurate FindMatches
	// transform, sometimes with unacceptable accuracy.
	//
	// Accuracy measures how well the transform finds true positives and true negatives.
	// Increasing accuracy requires more machine resources and cost. But it also
	// results in increased recall.
	//
	// Cost measures how many compute resources, and thus money, are consumed to
	// run the transform.
	AccuracyCostTradeoff *float64 `type:"double"`

	// The value to switch on or off to force the output to match the provided labels
	// from users. If the value is True, the find matches transform forces the output
	// to match the provided labels. The results override the normal conflation
	// results. If the value is False, the find matches transform does not ensure
	// all the labels provided are respected, and the results rely on the trained
	// model.
	//
	// Note that setting this value to true may increase the conflation execution
	// time.
	EnforceProvidedLabels *bool `type:"boolean"`

	// The value selected when tuning your transform for a balance between precision
	// and recall. A value of 0.5 means no preference; a value of 1.0 means a bias
	// purely for precision, and a value of 0.0 means a bias for recall. Because
	// this is a tradeoff, choosing values close to 1.0 means very low recall, and
	// choosing values close to 0.0 results in very low precision.
	//
	// The precision metric indicates how often your model is correct when it predicts
	// a match.
	//
	// The recall metric indicates that for an actual match, how often your model
	// predicts the match.
	PrecisionRecallTradeoff *float64 `type:"double"`

	// The name of a column that uniquely identifies rows in the source table. Used
	// to help identify matching records.
	PrimaryKeyColumnName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FindMatchesParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FindMatchesParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FindMatchesParameters"}
	if s.PrimaryKeyColumnName != nil && len(*s.PrimaryKeyColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PrimaryKeyColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configuration properties for a Find Matches task run.
type FindMatchesTaskRunProperties struct {
	_ struct{} `type:"structure"`

	// The job ID for the Find Matches task run.
	JobId *string `min:"1" type:"string"`

	// The name assigned to the job for the Find Matches task run.
	JobName *string `min:"1" type:"string"`

	// The job run ID for the Find Matches task run.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FindMatchesTaskRunProperties) String() string {
	return awsutil.Prettify(s)
}

// Filters the connection definitions that are returned by the GetConnections
// API operation.
type GetConnectionsFilter struct {
	_ struct{} `type:"structure"`

	// The type of connections to return. Currently, SFTP is not supported.
	ConnectionType ConnectionType `type:"string" enum:"true"`

	// A criteria string that must match the criteria recorded in the connection
	// definition for that connection definition to be returned.
	MatchCriteria []string `type:"list"`
}

// String returns the string representation
func (s GetConnectionsFilter) String() string {
	return awsutil.Prettify(s)
}

// A structure for returning a resource policy.
type GluePolicy struct {
	_ struct{} `type:"structure"`

	// The date and time at which the policy was created.
	CreateTime *time.Time `type:"timestamp"`

	// Contains the hash value associated with this policy.
	PolicyHash *string `min:"1" type:"string"`

	// Contains the requested policy document, in JSON format.
	PolicyInJson *string `min:"2" type:"string"`

	// The date and time at which the policy was last updated.
	UpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GluePolicy) String() string {
	return awsutil.Prettify(s)
}

// The database and table in the AWS Glue Data Catalog that is used for input
// or output data.
type GlueTable struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the AWS Glue Data Catalog.
	CatalogId *string `min:"1" type:"string"`

	// The name of the connection to the AWS Glue Data Catalog.
	ConnectionName *string `min:"1" type:"string"`

	// A database name in the AWS Glue Data Catalog.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A table name in the AWS Glue Data Catalog.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GlueTable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueTable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlueTable"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConnectionName", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier that uses grok patterns.
type GrokClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp"`

	// Optional custom grok patterns defined by this classifier. For more information,
	// see custom patterns in Writing Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	CustomPatterns *string `type:"string"`

	// The grok pattern applied to a data store by this classifier. For more information,
	// see built-in patterns in Writing Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GrokClassifier) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration properties for an importing labels task run.
type ImportLabelsTaskRunProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Simple Storage Service (Amazon S3) path from where you will import
	// the labels.
	InputS3Path *string `type:"string"`

	// Indicates whether to overwrite your existing labels.
	Replace *bool `type:"boolean"`
}

// String returns the string representation
func (s ImportLabelsTaskRunProperties) String() string {
	return awsutil.Prettify(s)
}

// Specifies a JDBC data store to crawl.
type JdbcTarget struct {
	_ struct{} `type:"structure"`

	// The name of the connection to use to connect to the JDBC target.
	ConnectionName *string `type:"string"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string `type:"list"`

	// The path of the JDBC target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s JdbcTarget) String() string {
	return awsutil.Prettify(s)
}

// Specifies a job definition.
type Job struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. Use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) allocated to runs of
	// this job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is
	// a relative measure of processing power that consists of 4 vCPUs of compute
	// capacity and 16 GB of memory. For more information, see the AWS Glue pricing
	// page (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that executes this job.
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The time and date that this job definition was created.
	CreatedOn *time.Time `type:"timestamp"`

	// The default arguments for this job, specified as name-value pairs.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string `type:"map"`

	// A description of the job.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for jobs
	// of type Spark.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Jobs that are created without specifying a Glue version default to Glue 0.9.
	GlueVersion *string `min:"1" type:"string"`

	// The last point in time when this job definition was modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a Python shell job or an Apache Spark ETL job:
	//
	//    * When you specify a Python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job after a JobRun fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job definition.
	Name *string `min:"1" type:"string"`

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]string `type:"map"`

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this
	// job.
	Role *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// Defines a point that a job can resume processing.
type JobBookmarkEntry struct {
	_ struct{} `type:"structure"`

	// The attempt ID number.
	Attempt *int64 `type:"integer"`

	// The bookmark itself.
	JobBookmark *string `type:"string"`

	// The name of the job in question.
	JobName *string `type:"string"`

	// The unique run identifier associated with the previous job run.
	PreviousRunId *string `type:"string"`

	// The run ID number.
	Run *int64 `type:"integer"`

	// The run ID number.
	RunId *string `type:"string"`

	// The version of the job.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s JobBookmarkEntry) String() string {
	return awsutil.Prettify(s)
}

// Specifies how job bookmark data should be encrypted.
type JobBookmarksEncryption struct {
	_ struct{} `type:"structure"`

	// The encryption mode to use for job bookmarks data.
	JobBookmarksEncryptionMode JobBookmarksEncryptionMode `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`
}

// String returns the string representation
func (s JobBookmarksEncryption) String() string {
	return awsutil.Prettify(s)
}

// Specifies code executed when a job is run.
type JobCommand struct {
	_ struct{} `type:"structure"`

	// The name of the job command. For an Apache Spark ETL job, this must be glueetl.
	// For a Python shell job, it must be pythonshell.
	Name *string `type:"string"`

	// The Python version being used to execute a Python shell job. Allowed values
	// are 2 or 3.
	PythonVersion *string `type:"string"`

	// Specifies the Amazon Simple Storage Service (Amazon S3) path to a script
	// that executes a job.
	ScriptLocation *string `type:"string"`
}

// String returns the string representation
func (s JobCommand) String() string {
	return awsutil.Prettify(s)
}

// The details of a Job node present in the workflow.
type JobNodeDetails struct {
	_ struct{} `type:"structure"`

	// The information for the job runs represented by the job node.
	JobRuns []JobRun `type:"list"`
}

// String returns the string representation
func (s JobNodeDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a job run.
type JobRun struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. Use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) allocated to this JobRun.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The job arguments associated with this run. For this job run, they replace
	// the default arguments set in the job definition itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own job arguments,
	// see the Calling AWS Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string `type:"map"`

	// The number of the attempt to run this job.
	Attempt *int64 `type:"integer"`

	// The date and time that this job run completed.
	CompletedOn *time.Time `type:"timestamp"`

	// An error message associated with this job run.
	ErrorMessage *string `type:"string"`

	// The amount of time (in seconds) that the job run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for jobs
	// of type Spark.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Jobs that are created without specifying a Glue version default to Glue 0.9.
	GlueVersion *string `min:"1" type:"string"`

	// The ID of this job run.
	Id *string `min:"1" type:"string"`

	// The name of the job definition being used in this run.
	JobName *string `min:"1" type:"string"`

	// The current state of the job run. For more information about the statuses
	// of jobs that have terminated abnormally, see AWS Glue Job Run Statuses (https://docs.aws.amazon.com/glue/latest/dg/job-run-statuses.html).
	JobRunState JobRunState `type:"string" enum:"true"`

	// The last time that this job run was modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The name of the log group for secure logging that can be server-side encrypted
	// in Amazon CloudWatch using AWS KMS. This name can be /aws-glue/jobs/, in
	// which case the default encryption is NONE. If you add a role name and SecurityConfiguration
	// name (in other words, /aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/),
	// then that security configuration is used to encrypt the log group.
	LogGroupName *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://docs.aws.amazon.com/https:/aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a Python shell job or an Apache Spark ETL job:
	//
	//    * When you specify a Python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// A list of predecessors to this job run.
	PredecessorRuns []Predecessor `type:"list"`

	// The ID of the previous run of this job. For example, the JobRunId specified
	// in the StartJobRun action.
	PreviousRunId *string `min:"1" type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job
	// run.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The date and time at which this job run was started.
	StartedOn *time.Time `type:"timestamp"`

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The
	// default is 2,880 minutes (48 hours). This overrides the timeout value set
	// in the parent job.
	Timeout *int64 `min:"1" type:"integer"`

	// The name of the trigger that started this job run.
	TriggerName *string `min:"1" type:"string"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// Specifies information used to update an existing job definition. The previous
// job definition is completely overwritten by this information.
type JobUpdate struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. Use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) to allocate to this job.
	// You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that executes this job (required).
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string `type:"map"`

	// Description of the job being defined.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for jobs
	// of type Spark.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a Python shell job or an Apache Spark ETL job:
	//
	//    * When you specify a Python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]string `type:"map"`

	// Specifies the configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this
	// job (required).
	Role *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobUpdate"}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier for JSON content.
type JsonClassifier struct {
	_ struct{} `type:"structure"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s JsonClassifier) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration properties for a labeling set generation task run.
type LabelingSetGenerationTaskRunProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Simple Storage Service (Amazon S3) path where you will generate
	// the labeling set.
	OutputS3Path *string `type:"string"`
}

// String returns the string representation
func (s LabelingSetGenerationTaskRunProperties) String() string {
	return awsutil.Prettify(s)
}

// Status and error information about the most recent crawl.
type LastCrawlInfo struct {
	_ struct{} `type:"structure"`

	// If an error occurred, the error information about the last crawl.
	ErrorMessage *string `type:"string"`

	// The log group for the last crawl.
	LogGroup *string `min:"1" type:"string"`

	// The log stream for the last crawl.
	LogStream *string `min:"1" type:"string"`

	// The prefix for a message about this crawl.
	MessagePrefix *string `min:"1" type:"string"`

	// The time at which the crawl started.
	StartTime *time.Time `type:"timestamp"`

	// Status of the last crawl.
	Status LastCrawlStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s LastCrawlInfo) String() string {
	return awsutil.Prettify(s)
}

// The location of resources.
type Location struct {
	_ struct{} `type:"structure"`

	// An Amazon DynamoDB table location.
	DynamoDB []CodeGenNodeArg `type:"list"`

	// A JDBC location.
	Jdbc []CodeGenNodeArg `type:"list"`

	// An Amazon Simple Storage Service (Amazon S3) location.
	S3 []CodeGenNodeArg `type:"list"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Location"}
	if s.DynamoDB != nil {
		for i, v := range s.DynamoDB {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DynamoDB", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Jdbc != nil {
		for i, v := range s.Jdbc {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Jdbc", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.S3 != nil {
		for i, v := range s.S3 {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a long column statistics data.
type LongColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Maximum value of the column.
	MaximumValue *int64 `type:"long"`

	// Minimum value of the column.
	MinimumValue *int64 `type:"long"`

	// Number of distinct values.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s LongColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LongColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LongColumnStatisticsData"}

	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDistinctValues"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A structure for a machine learning transform.
type MLTransform struct {
	_ struct{} `type:"structure"`

	// A timestamp. The time and date that this machine learning transform was created.
	CreatedOn *time.Time `type:"timestamp"`

	// A user-defined, long-form description text for the machine learning transform.
	// Descriptions are not guaranteed to be unique and can be changed at any time.
	Description *string `type:"string"`

	// An EvaluationMetrics object. Evaluation metrics provide an estimate of the
	// quality of your machine learning transform.
	EvaluationMetrics *EvaluationMetrics `type:"structure"`

	// This value determines which version of AWS Glue this machine learning transform
	// is compatible with. Glue 1.0 is recommended for most customers. If the value
	// is not set, the Glue compatibility defaults to Glue 0.9. For more information,
	// see AWS Glue Versions (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// A list of AWS Glue table definitions used by the transform.
	InputRecordTables []GlueTable `type:"list"`

	// A count identifier for the labeling files generated by AWS Glue for this
	// transform. As you create a better transform, you can iteratively download,
	// label, and upload the labeling file.
	LabelCount *int64 `type:"integer"`

	// A timestamp. The last point in time when this machine learning transform
	// was modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The number of AWS Glue data processing units (DPUs) that are allocated to
	// task runs for this transform. You can allocate from 2 to 100 DPUs; the default
	// is 10. A DPU is a relative measure of processing power that consists of 4
	// vCPUs of compute capacity and 16 GB of memory. For more information, see
	// the AWS Glue pricing page (http://aws.amazon.com/glue/pricing/).
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry after an MLTaskRun of the machine learning
	// transform fails.
	MaxRetries *int64 `type:"integer"`

	// A user-defined name for the machine learning transform. Names are not guaranteed
	// unique and can be changed at any time.
	Name *string `min:"1" type:"string"`

	// The number of workers of a defined workerType that are allocated when a task
	// of the transform runs.
	//
	// If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	NumberOfWorkers *int64 `type:"integer"`

	// A TransformParameters object. You can use parameters to tune (customize)
	// the behavior of the machine learning transform by specifying what data it
	// learns from and your preference on various tradeoffs (such as precious vs.
	// recall, or accuracy vs. cost).
	Parameters *TransformParameters `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the IAM role with the required
	// permissions. The required permissions include both AWS Glue service role
	// permissions to AWS Glue resources, and Amazon S3 permissions required by
	// the transform.
	//
	//    * This role needs AWS Glue service role permissions to allow access to
	//    resources in AWS Glue. See Attach a Policy to IAM Users That Access AWS
	//    Glue (https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
	//
	//    * This role needs permission to your Amazon Simple Storage Service (Amazon
	//    S3) sources, targets, temporary directory, scripts, and any libraries
	//    used by the task run for this transform.
	Role *string `type:"string"`

	// A map of key-value pairs representing the columns and data types that this
	// transform can run against. Has an upper bound of 100 columns.
	Schema []SchemaColumn `type:"list"`

	// The current status of the machine learning transform.
	Status TransformStatusType `type:"string" enum:"true"`

	// The timeout in minutes of the machine learning transform.
	Timeout *int64 `min:"1" type:"integer"`

	// The unique transform ID that is generated for the machine learning transform.
	// The ID is guaranteed to be unique and does not change.
	TransformId *string `min:"1" type:"string"`

	// The type of predefined worker that is allocated when a task of this transform
	// runs. Accepts a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s MLTransform) String() string {
	return awsutil.Prettify(s)
}

// Defines a mapping.
type MappingEntry struct {
	_ struct{} `type:"structure"`

	// The source path.
	SourcePath *string `type:"string"`

	// The name of the source table.
	SourceTable *string `type:"string"`

	// The source type.
	SourceType *string `type:"string"`

	// The target path.
	TargetPath *string `type:"string"`

	// The target table.
	TargetTable *string `type:"string"`

	// The target type.
	TargetType *string `type:"string"`
}

// String returns the string representation
func (s MappingEntry) String() string {
	return awsutil.Prettify(s)
}

// A node represents an AWS Glue component like Trigger, Job etc. which is part
// of a workflow.
type Node struct {
	_ struct{} `type:"structure"`

	// Details of the crawler when the node represents a crawler.
	CrawlerDetails *CrawlerNodeDetails `type:"structure"`

	// Details of the Job when the node represents a Job.
	JobDetails *JobNodeDetails `type:"structure"`

	// The name of the AWS Glue component represented by the node.
	Name *string `min:"1" type:"string"`

	// Details of the Trigger when the node represents a Trigger.
	TriggerDetails *TriggerNodeDetails `type:"structure"`

	// The type of AWS Glue component represented by the node.
	Type NodeType `type:"string" enum:"true"`

	// The unique Id assigned to the node within the workflow.
	UniqueId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration properties of a notification.
type NotificationProperty struct {
	_ struct{} `type:"structure"`

	// After a job run starts, the number of minutes to wait before sending a job
	// run delay notification.
	NotifyDelayAfter *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s NotificationProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotificationProperty"}
	if s.NotifyDelayAfter != nil && *s.NotifyDelayAfter < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NotifyDelayAfter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the sort order of a sorted column.
type Order struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// Column is a required field
	Column *string `min:"1" type:"string" required:"true"`

	// Indicates that the column is sorted in ascending order (== 1), or in descending
	// order (==0).
	//
	// SortOrder is a required field
	SortOrder *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Order) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Order) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Order"}

	if s.Column == nil {
		invalidParams.Add(aws.NewErrParamRequired("Column"))
	}
	if s.Column != nil && len(*s.Column) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Column", 1))
	}

	if s.SortOrder == nil {
		invalidParams.Add(aws.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a slice of table data.
type Partition struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the partition resides.
	CatalogId *string `min:"1" type:"string"`

	// The time at which the partition was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the catalog database in which to create the partition.
	DatabaseName *string `min:"1" type:"string"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp"`

	// These key-value pairs define partition parameters.
	Parameters map[string]string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The name of the database table in which to create the partition.
	TableName *string `min:"1" type:"string"`

	// The values of the partition.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Partition) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a partition error.
type PartitionError struct {
	_ struct{} `type:"structure"`

	// The details about the partition error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The values that define the partition.
	PartitionValues []string `type:"list"`
}

// String returns the string representation
func (s PartitionError) String() string {
	return awsutil.Prettify(s)
}

// The structure used to create and update a partition.
type PartitionInput struct {
	_ struct{} `type:"structure"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp"`

	// These key-value pairs define partition parameters.
	Parameters map[string]string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The values of the partition. Although this parameter is not required by the
	// SDK, you must specify this parameter for a valid input.
	//
	// The values for the keys for the new partition must be passed as an array
	// of String objects that must be ordered in the same order as the partition
	// keys appearing in the Amazon S3 prefix. Otherwise AWS Glue will add the values
	// to the wrong keys.
	Values []string `type:"list"`
}

// String returns the string representation
func (s PartitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PartitionInput"}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains a list of values defining partitions.
type PartitionValueList struct {
	_ struct{} `type:"structure"`

	// The list of values.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s PartitionValueList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionValueList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PartitionValueList"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the physical requirements for a connection.
type PhysicalConnectionRequirements struct {
	_ struct{} `type:"structure"`

	// The connection's Availability Zone. This field is redundant because the specified
	// subnet implies the Availability Zone to be used. Currently the field must
	// be populated, but it will be deprecated in the future.
	AvailabilityZone *string `min:"1" type:"string"`

	// The security group ID list used by the connection.
	SecurityGroupIdList []string `type:"list"`

	// The subnet ID used by the connection.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PhysicalConnectionRequirements) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalConnectionRequirements) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PhysicalConnectionRequirements"}
	if s.AvailabilityZone != nil && len(*s.AvailabilityZone) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AvailabilityZone", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A job run that was used in the predicate of a conditional trigger that triggered
// this job run.
type Predecessor struct {
	_ struct{} `type:"structure"`

	// The name of the job definition used by the predecessor job run.
	JobName *string `min:"1" type:"string"`

	// The job-run ID of the predecessor job run.
	RunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Predecessor) String() string {
	return awsutil.Prettify(s)
}

// Defines the predicate of the trigger, which determines when it fires.
type Predicate struct {
	_ struct{} `type:"structure"`

	// A list of the conditions that determine when the trigger will fire.
	Conditions []Condition `type:"list"`

	// An optional field if only one condition is listed. If multiple conditions
	// are listed, then this field is required.
	Logical Logical `type:"string" enum:"true"`
}

// String returns the string representation
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Predicate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Predicate"}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Permissions granted to a principal.
type PrincipalPermissions struct {
	_ struct{} `type:"structure"`

	// The permissions that are granted to the principal.
	Permissions []Permission `type:"list"`

	// The principal who is granted permissions.
	Principal *DataLakePrincipal `type:"structure"`
}

// String returns the string representation
func (s PrincipalPermissions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrincipalPermissions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PrincipalPermissions"}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a property predicate.
type PropertyPredicate struct {
	_ struct{} `type:"structure"`

	// The comparator used to compare this property to others.
	Comparator Comparator `type:"string" enum:"true"`

	// The key of the property.
	Key *string `type:"string"`

	// The value of the property.
	Value *string `type:"string"`
}

// String returns the string representation
func (s PropertyPredicate) String() string {
	return awsutil.Prettify(s)
}

// The URIs for function resources.
type ResourceUri struct {
	_ struct{} `type:"structure"`

	// The type of the resource.
	ResourceType ResourceType `type:"string" enum:"true"`

	// The URI for accessing the resource.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceUri) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceUri) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceUri"}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies how Amazon Simple Storage Service (Amazon S3) data should be encrypted.
type S3Encryption struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`

	// The encryption mode to use for Amazon S3 data.
	S3EncryptionMode S3EncryptionMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3Encryption) String() string {
	return awsutil.Prettify(s)
}

// Specifies a data store in Amazon Simple Storage Service (Amazon S3).
type S3Target struct {
	_ struct{} `type:"structure"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string `type:"list"`

	// The path to the Amazon S3 target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s S3Target) String() string {
	return awsutil.Prettify(s)
}

// A scheduling object using a cron statement to schedule an event.
type Schedule struct {
	_ struct{} `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	ScheduleExpression *string `type:"string"`

	// The state of the schedule.
	State ScheduleState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// A policy that specifies update and deletion behaviors for the crawler.
type SchemaChangePolicy struct {
	_ struct{} `type:"structure"`

	// The deletion behavior when the crawler finds a deleted object.
	DeleteBehavior DeleteBehavior `type:"string" enum:"true"`

	// The update behavior when the crawler finds a changed schema.
	UpdateBehavior UpdateBehavior `type:"string" enum:"true"`
}

// String returns the string representation
func (s SchemaChangePolicy) String() string {
	return awsutil.Prettify(s)
}

// A key-value pair representing a column and data type that this transform
// can run against. The Schema parameter of the MLTransform may contain up to
// 100 of these structures.
type SchemaColumn struct {
	_ struct{} `type:"structure"`

	// The type of data in the column.
	DataType *string `type:"string"`

	// The name of the column.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SchemaColumn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaColumn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SchemaColumn"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a security configuration.
type SecurityConfiguration struct {
	_ struct{} `type:"structure"`

	// The time at which this security configuration was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The encryption configuration associated with this security configuration.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The name of the security configuration.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SecurityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Defines a non-overlapping region of a table's partitions, allowing multiple
// requests to be executed in parallel.
type Segment struct {
	_ struct{} `type:"structure"`

	// The zero-based index number of the segment. For example, if the total number
	// of segments is 4, SegmentNumber values range from 0 through 3.
	//
	// SegmentNumber is a required field
	SegmentNumber *int64 `type:"integer" required:"true"`

	// The total number of segments.
	//
	// TotalSegments is a required field
	TotalSegments *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Segment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Segment"}

	if s.SegmentNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentNumber"))
	}

	if s.TotalSegments == nil {
		invalidParams.Add(aws.NewErrParamRequired("TotalSegments"))
	}
	if s.TotalSegments != nil && *s.TotalSegments < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TotalSegments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a serialization/deserialization program (SerDe) that serves
// as an extractor and loader.
type SerDeInfo struct {
	_ struct{} `type:"structure"`

	// Name of the SerDe.
	Name *string `min:"1" type:"string"`

	// These key-value pairs define initialization parameters for the SerDe.
	Parameters map[string]string `type:"map"`

	// Usually the class that implements the SerDe. An example is org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
	SerializationLibrary *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SerDeInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SerDeInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SerDeInfo"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.SerializationLibrary != nil && len(*s.SerializationLibrary) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SerializationLibrary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies skewed values in a table. Skewed values are those that occur with
// very high frequency.
type SkewedInfo struct {
	_ struct{} `type:"structure"`

	// A list of names of columns that contain skewed values.
	SkewedColumnNames []string `type:"list"`

	// A mapping of skewed values to the columns that contain them.
	SkewedColumnValueLocationMaps map[string]string `type:"map"`

	// A list of values that appear so frequently as to be considered skewed.
	SkewedColumnValues []string `type:"list"`
}

// String returns the string representation
func (s SkewedInfo) String() string {
	return awsutil.Prettify(s)
}

// Specifies a field to sort by and a sort order.
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The name of the field on which to sort.
	FieldName *string `type:"string"`

	// An ascending or descending sort.
	Sort Sort `type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// Describes the physical storage of table data.
type StorageDescriptor struct {
	_ struct{} `type:"structure"`

	// A list of reducer grouping columns, clustering columns, and bucketing columns
	// in the table.
	BucketColumns []string `type:"list"`

	// A list of the Columns in the table.
	Columns []Column `type:"list"`

	// True if the data in the table is compressed, or False if not.
	Compressed *bool `type:"boolean"`

	// The input format: SequenceFileInputFormat (binary), or TextInputFormat, or
	// a custom format.
	InputFormat *string `type:"string"`

	// The physical location of the table. By default, this takes the form of the
	// warehouse location, followed by the database location in the warehouse, followed
	// by the table name.
	Location *string `type:"string"`

	// Must be specified if the table contains any dimension columns.
	NumberOfBuckets *int64 `type:"integer"`

	// The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat,
	// or a custom format.
	OutputFormat *string `type:"string"`

	// The user-supplied properties in key-value form.
	Parameters map[string]string `type:"map"`

	// The serialization/deserialization (SerDe) information.
	SerdeInfo *SerDeInfo `type:"structure"`

	// The information about values that appear frequently in a column (skewed values).
	SkewedInfo *SkewedInfo `type:"structure"`

	// A list specifying the sort order of each bucket in the table.
	SortColumns []Order `type:"list"`

	// True if the table data is stored in subdirectories, or False if not.
	StoredAsSubDirectories *bool `type:"boolean"`
}

// String returns the string representation
func (s StorageDescriptor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageDescriptor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageDescriptor"}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SerdeInfo != nil {
		if err := s.SerdeInfo.Validate(); err != nil {
			invalidParams.AddNested("SerdeInfo", err.(aws.ErrInvalidParams))
		}
	}
	if s.SortColumns != nil {
		for i, v := range s.SortColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a string column statistics data.
type StringColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Average value of the column.
	//
	// AverageLength is a required field
	AverageLength *float64 `type:"double" required:"true"`

	// Maximum value of the column.
	//
	// MaximumLength is a required field
	MaximumLength *int64 `type:"long" required:"true"`

	// Number of distinct values.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// Number of nulls.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s StringColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringColumnStatisticsData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StringColumnStatisticsData"}

	if s.AverageLength == nil {
		invalidParams.Add(aws.NewErrParamRequired("AverageLength"))
	}

	if s.MaximumLength == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaximumLength"))
	}

	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDistinctValues"))
	}

	if s.NumberOfNulls == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a collection of related data organized in columns and rows.
type Table struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the table resides.
	CatalogId *string `min:"1" type:"string"`

	// The time when the table definition was created in the Data Catalog.
	CreateTime *time.Time `type:"timestamp"`

	// The person or entity who created the table.
	CreatedBy *string `min:"1" type:"string"`

	// The name of the database where the table metadata resides. For Hive compatibility,
	// this must be all lowercase.
	DatabaseName *string `min:"1" type:"string"`

	// A description of the table.
	Description *string `type:"string"`

	// Indicates whether the table has been registered with AWS Lake Formation.
	IsRegisteredWithLakeFormation *bool `type:"boolean"`

	// The last time that the table was accessed. This is usually taken from HDFS,
	// and might not be reliable.
	LastAccessTime *time.Time `type:"timestamp"`

	// The last time that column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp"`

	// The table name. For Hive compatibility, this must be entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The owner of the table.
	Owner *string `min:"1" type:"string"`

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	//
	// When you create a table used by Amazon Athena, and you do not specify any
	// partitionKeys, you must at least set the value of partitionKeys to an empty
	// list. For example:
	//
	// "PartitionKeys": []
	PartitionKeys []Column `type:"list"`

	// The retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// A TableIdentifier structure that describes a target table for resource linking.
	TargetTable *TableIdentifier `type:"structure"`

	// The last time that the table was updated.
	UpdateTime *time.Time `type:"timestamp"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// An error record for table operations.
type TableError struct {
	_ struct{} `type:"structure"`

	// The details about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the table. For Hive compatibility, this must be entirely lowercase.
	TableName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableError) String() string {
	return awsutil.Prettify(s)
}

// A structure that describes a target table for resource linking.
type TableIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the table resides.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database that contains the target table.
	DatabaseName *string `min:"1" type:"string"`

	// The name of the target table.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TableIdentifier"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A structure used to define a table.
type TableInput struct {
	_ struct{} `type:"structure"`

	// A description of the table.
	Description *string `type:"string"`

	// The last time that the table was accessed.
	LastAccessTime *time.Time `type:"timestamp"`

	// The last time that column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp"`

	// The table name. For Hive compatibility, this is folded to lowercase when
	// it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The table owner.
	Owner *string `min:"1" type:"string"`

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	//
	// When you create a table used by Amazon Athena, and you do not specify any
	// partitionKeys, you must at least set the value of partitionKeys to an empty
	// list. For example:
	//
	// "PartitionKeys": []
	PartitionKeys []Column `type:"list"`

	// The retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// A TableIdentifier structure that describes a target table for resource linking.
	TargetTable *TableIdentifier `type:"structure"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s TableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TableInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Owner", 1))
	}
	if s.PartitionKeys != nil {
		for i, v := range s.PartitionKeys {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionKeys", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(aws.ErrInvalidParams))
		}
	}
	if s.TargetTable != nil {
		if err := s.TargetTable.Validate(); err != nil {
			invalidParams.AddNested("TargetTable", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a version of a table.
type TableVersion struct {
	_ struct{} `type:"structure"`

	// The table in question.
	Table *Table `type:"structure"`

	// The ID value that identifies this table version. A VersionId is a string
	// representation of an integer. Each version is incremented by 1.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersion) String() string {
	return awsutil.Prettify(s)
}

// An error record for table-version operations.
type TableVersionError struct {
	_ struct{} `type:"structure"`

	// The details about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the table in question.
	TableName *string `min:"1" type:"string"`

	// The ID value of the version in question. A VersionID is a string representation
	// of an integer. Each version is incremented by 1.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersionError) String() string {
	return awsutil.Prettify(s)
}

// The sampling parameters that are associated with the machine learning transform.
type TaskRun struct {
	_ struct{} `type:"structure"`

	// The last point in time that the requested task run was completed.
	CompletedOn *time.Time `type:"timestamp"`

	// The list of error strings associated with this task run.
	ErrorString *string `type:"string"`

	// The amount of time (in seconds) that the task run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// The last point in time that the requested task run was updated.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The names of the log group for secure logging, associated with this task
	// run.
	LogGroupName *string `type:"string"`

	// Specifies configuration properties associated with this task run.
	Properties *TaskRunProperties `type:"structure"`

	// The date and time that this task run started.
	StartedOn *time.Time `type:"timestamp"`

	// The current status of the requested task run.
	Status TaskStatusType `type:"string" enum:"true"`

	// The unique identifier for this task run.
	TaskRunId *string `min:"1" type:"string"`

	// The unique identifier for the transform.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TaskRun) String() string {
	return awsutil.Prettify(s)
}

// The criteria that are used to filter the task runs for the machine learning
// transform.
type TaskRunFilterCriteria struct {
	_ struct{} `type:"structure"`

	// Filter on task runs started after this date.
	StartedAfter *time.Time `type:"timestamp"`

	// Filter on task runs started before this date.
	StartedBefore *time.Time `type:"timestamp"`

	// The current status of the task run.
	Status TaskStatusType `type:"string" enum:"true"`

	// The type of task run.
	TaskRunType TaskType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TaskRunFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// The configuration properties for the task run.
type TaskRunProperties struct {
	_ struct{} `type:"structure"`

	// The configuration properties for an exporting labels task run.
	ExportLabelsTaskRunProperties *ExportLabelsTaskRunProperties `type:"structure"`

	// The configuration properties for a find matches task run.
	FindMatchesTaskRunProperties *FindMatchesTaskRunProperties `type:"structure"`

	// The configuration properties for an importing labels task run.
	ImportLabelsTaskRunProperties *ImportLabelsTaskRunProperties `type:"structure"`

	// The configuration properties for a labeling set generation task run.
	LabelingSetGenerationTaskRunProperties *LabelingSetGenerationTaskRunProperties `type:"structure"`

	// The type of task run.
	TaskType TaskType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TaskRunProperties) String() string {
	return awsutil.Prettify(s)
}

// The sorting criteria that are used to sort the list of task runs for the
// machine learning transform.
type TaskRunSortCriteria struct {
	_ struct{} `type:"structure"`

	// The column to be used to sort the list of task runs for the machine learning
	// transform.
	//
	// Column is a required field
	Column TaskRunSortColumnType `type:"string" required:"true" enum:"true"`

	// The sort direction to be used to sort the list of task runs for the machine
	// learning transform.
	//
	// SortDirection is a required field
	SortDirection SortDirectionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TaskRunSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskRunSortCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TaskRunSortCriteria"}
	if len(s.Column) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Column"))
	}
	if len(s.SortDirection) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SortDirection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The criteria used to filter the machine learning transforms.
type TransformFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The time and date after which the transforms were created.
	CreatedAfter *time.Time `type:"timestamp"`

	// The time and date before which the transforms were created.
	CreatedBefore *time.Time `type:"timestamp"`

	// This value determines which version of AWS Glue this machine learning transform
	// is compatible with. Glue 1.0 is recommended for most customers. If the value
	// is not set, the Glue compatibility defaults to Glue 0.9. For more information,
	// see AWS Glue Versions (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// Filter on transforms last modified after this date.
	LastModifiedAfter *time.Time `type:"timestamp"`

	// Filter on transforms last modified before this date.
	LastModifiedBefore *time.Time `type:"timestamp"`

	// A unique transform name that is used to filter the machine learning transforms.
	Name *string `min:"1" type:"string"`

	// Filters on datasets with a specific schema. The Map<Column, Type> object
	// is an array of key-value pairs representing the schema this transform accepts,
	// where Column is the name of a column, and Type is the type of the data such
	// as an integer or string. Has an upper bound of 100 columns.
	Schema []SchemaColumn `type:"list"`

	// Filters the list of machine learning transforms by the last known status
	// of the transforms (to indicate whether a transform can be used or not). One
	// of "NOT_READY", "READY", or "DELETING".
	Status TransformStatusType `type:"string" enum:"true"`

	// The type of machine learning transform that is used to filter the machine
	// learning transforms.
	TransformType TransformType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TransformFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformFilterCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformFilterCriteria"}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Schema != nil {
		for i, v := range s.Schema {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schema", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The algorithm-specific parameters that are associated with the machine learning
// transform.
type TransformParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for the find matches algorithm.
	FindMatchesParameters *FindMatchesParameters `type:"structure"`

	// The type of machine learning transform.
	//
	// For information about the types of machine learning transforms, see Creating
	// Machine Learning Transforms (http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
	//
	// TransformType is a required field
	TransformType TransformType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TransformParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformParameters"}
	if len(s.TransformType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TransformType"))
	}
	if s.FindMatchesParameters != nil {
		if err := s.FindMatchesParameters.Validate(); err != nil {
			invalidParams.AddNested("FindMatchesParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The sorting criteria that are associated with the machine learning transform.
type TransformSortCriteria struct {
	_ struct{} `type:"structure"`

	// The column to be used in the sorting criteria that are associated with the
	// machine learning transform.
	//
	// Column is a required field
	Column TransformSortColumnType `type:"string" required:"true" enum:"true"`

	// The sort direction to be used in the sorting criteria that are associated
	// with the machine learning transform.
	//
	// SortDirection is a required field
	SortDirection SortDirectionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TransformSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformSortCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformSortCriteria"}
	if len(s.Column) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Column"))
	}
	if len(s.SortDirection) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SortDirection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a specific trigger.
type Trigger struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Id *string `min:"1" type:"string"`

	// The name of the trigger.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// The current state of the trigger.
	State TriggerState `type:"string" enum:"true"`

	// The type of trigger that this is.
	Type TriggerType `type:"string" enum:"true"`

	// The name of the workflow associated with the trigger.
	WorkflowName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// The details of a Trigger node present in the workflow.
type TriggerNodeDetails struct {
	_ struct{} `type:"structure"`

	// The information of the trigger represented by the trigger node.
	Trigger *Trigger `type:"structure"`
}

// String returns the string representation
func (s TriggerNodeDetails) String() string {
	return awsutil.Prettify(s)
}

// A structure used to provide information used to update a trigger. This object
// updates the previous trigger definition by overwriting it completely.
type TriggerUpdate struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s TriggerUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TriggerUpdate"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a custom CSV classifier to be updated.
type UpdateCsvClassifierRequest struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// It must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateCsvClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCsvClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCsvClassifierRequest"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Delimiter", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.QuoteSymbol != nil && len(*s.QuoteSymbol) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuoteSymbol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a grok classifier to update when passed to UpdateClassifier.
type UpdateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	Classification *string `type:"string"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	GrokPattern *string `min:"1" type:"string"`

	// The name of the GrokClassifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGrokClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGrokClassifierRequest"}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrokPattern", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a JSON classifier to be updated.
type UpdateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	JsonPath *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJsonClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateJsonClassifierRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an XML classifier to be updated.
type UpdateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	Classification *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This cannot identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s UpdateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateXMLClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateXMLClassifierRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the equivalent of a Hive user-defined function (UDF) definition.
type UserDefinedFunction struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the function resides.
	CatalogId *string `min:"1" type:"string"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The time at which the function was created.
	CreateTime *time.Time `type:"timestamp"`

	// The name of the catalog database that contains the function.
	DatabaseName *string `min:"1" type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType PrincipalType `type:"string" enum:"true"`

	// The resource URIs for the function.
	ResourceUris []ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunction) String() string {
	return awsutil.Prettify(s)
}

// A structure used to create or update a user-defined function.
type UserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType PrincipalType `type:"string" enum:"true"`

	// The resource URIs for the function.
	ResourceUris []ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserDefinedFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserDefinedFunctionInput"}
	if s.ClassName != nil && len(*s.ClassName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClassName", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.OwnerName != nil && len(*s.OwnerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OwnerName", 1))
	}
	if s.ResourceUris != nil {
		for i, v := range s.ResourceUris {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceUris", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A workflow represents a flow in which AWS Glue components should be executed
// to complete a logical task.
type Workflow struct {
	_ struct{} `type:"structure"`

	// The date and time when the workflow was created.
	CreatedOn *time.Time `type:"timestamp"`

	// A collection of properties to be used as part of each execution of the workflow.
	DefaultRunProperties map[string]string `type:"map"`

	// A description of the workflow.
	Description *string `type:"string"`

	// The graph representing all the AWS Glue components that belong to the workflow
	// as nodes and directed connections between them as edges.
	Graph *WorkflowGraph `type:"structure"`

	// The date and time when the workflow was last modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The information about the last execution of the workflow.
	LastRun *WorkflowRun `type:"structure"`

	// The name of the workflow representing the flow.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Workflow) String() string {
	return awsutil.Prettify(s)
}

// A workflow graph represents the complete workflow containing all the AWS
// Glue components present in the workflow and all the directed connections
// between them.
type WorkflowGraph struct {
	_ struct{} `type:"structure"`

	// A list of all the directed connections between the nodes belonging to the
	// workflow.
	Edges []Edge `type:"list"`

	// A list of the the AWS Glue components belong to the workflow represented
	// as nodes.
	Nodes []Node `type:"list"`
}

// String returns the string representation
func (s WorkflowGraph) String() string {
	return awsutil.Prettify(s)
}

// A workflow run is an execution of a workflow providing all the runtime information.
type WorkflowRun struct {
	_ struct{} `type:"structure"`

	// The date and time when the workflow run completed.
	CompletedOn *time.Time `type:"timestamp"`

	// The graph representing all the AWS Glue components that belong to the workflow
	// as nodes and directed connections between them as edges.
	Graph *WorkflowGraph `type:"structure"`

	// Name of the workflow which was executed.
	Name *string `min:"1" type:"string"`

	// The date and time when the workflow run was started.
	StartedOn *time.Time `type:"timestamp"`

	// The statistics of the run.
	Statistics *WorkflowRunStatistics `type:"structure"`

	// The status of the workflow run.
	Status WorkflowRunStatus `type:"string" enum:"true"`

	// The ID of this workflow run.
	WorkflowRunId *string `min:"1" type:"string"`

	// The workflow run properties which were set during the run.
	WorkflowRunProperties map[string]string `type:"map"`
}

// String returns the string representation
func (s WorkflowRun) String() string {
	return awsutil.Prettify(s)
}

// Workflow run statistics provides statistics about the workflow run.
type WorkflowRunStatistics struct {
	_ struct{} `type:"structure"`

	// Total number of Actions which have failed.
	FailedActions *int64 `type:"integer"`

	// Total number Actions in running state.
	RunningActions *int64 `type:"integer"`

	// Total number of Actions which have stopped.
	StoppedActions *int64 `type:"integer"`

	// Total number of Actions which have succeeded.
	SucceededActions *int64 `type:"integer"`

	// Total number of Actions which timed out.
	TimeoutActions *int64 `type:"integer"`

	// Total number of Actions in the workflow run.
	TotalActions *int64 `type:"integer"`
}

// String returns the string representation
func (s WorkflowRunStatistics) String() string {
	return awsutil.Prettify(s)
}

// A classifier for XML content.
type XMLClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s XMLClassifier) String() string {
	return awsutil.Prettify(s)
}
