// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutWorkflowRunPropertiesInput struct {
	_ struct{} `type:"structure"`

	// Name of the workflow which was run.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ID of the workflow run for which the run properties should be updated.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`

	// The properties to put for the specified run.
	//
	// RunProperties is a required field
	RunProperties map[string]string `type:"map" required:"true"`
}

// String returns the string representation
func (s PutWorkflowRunPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutWorkflowRunPropertiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutWorkflowRunPropertiesInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RunId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RunId", 1))
	}

	if s.RunProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutWorkflowRunPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutWorkflowRunPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutWorkflowRunProperties = "PutWorkflowRunProperties"

// PutWorkflowRunPropertiesRequest returns a request value for making API operation for
// AWS Glue.
//
// Puts the specified workflow run properties for the given workflow run. If
// a property already exists for the specified run, then it overrides the value
// otherwise adds the property to existing properties.
//
//    // Example sending a request using PutWorkflowRunPropertiesRequest.
//    req := client.PutWorkflowRunPropertiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties
func (c *Client) PutWorkflowRunPropertiesRequest(input *PutWorkflowRunPropertiesInput) PutWorkflowRunPropertiesRequest {
	op := &aws.Operation{
		Name:       opPutWorkflowRunProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutWorkflowRunPropertiesInput{}
	}

	req := c.newRequest(op, input, &PutWorkflowRunPropertiesOutput{})

	return PutWorkflowRunPropertiesRequest{Request: req, Input: input, Copy: c.PutWorkflowRunPropertiesRequest}
}

// PutWorkflowRunPropertiesRequest is the request type for the
// PutWorkflowRunProperties API operation.
type PutWorkflowRunPropertiesRequest struct {
	*aws.Request
	Input *PutWorkflowRunPropertiesInput
	Copy  func(*PutWorkflowRunPropertiesInput) PutWorkflowRunPropertiesRequest
}

// Send marshals and sends the PutWorkflowRunProperties API request.
func (r PutWorkflowRunPropertiesRequest) Send(ctx context.Context) (*PutWorkflowRunPropertiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutWorkflowRunPropertiesResponse{
		PutWorkflowRunPropertiesOutput: r.Request.Data.(*PutWorkflowRunPropertiesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutWorkflowRunPropertiesResponse is the response type for the
// PutWorkflowRunProperties API operation.
type PutWorkflowRunPropertiesResponse struct {
	*PutWorkflowRunPropertiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutWorkflowRunProperties request.
func (r *PutWorkflowRunPropertiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
