// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is provided,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table to be deleted. For Hive compatibility, this name is
	// entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest returns a request value for making API operation for
// AWS Glue.
//
// Removes a table definition from the Data Catalog.
//
// After completing this operation, you no longer have access to the table versions
// and partitions that belong to the deleted table. AWS Glue deletes these "orphaned"
// resources asynchronously in a timely manner, at the discretion of the service.
//
// To ensure the immediate deletion of all related resources, before calling
// DeleteTable, use DeleteTableVersion or BatchDeleteTableVersion, and DeletePartition
// or BatchDeletePartition, to delete any resources that belong to the table.
//
//    // Example sending a request using DeleteTableRequest.
//    req := client.DeleteTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable
func (c *Client) DeleteTableRequest(input *DeleteTableInput) DeleteTableRequest {
	op := &aws.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	req := c.newRequest(op, input, &DeleteTableOutput{})

	return DeleteTableRequest{Request: req, Input: input, Copy: c.DeleteTableRequest}
}

// DeleteTableRequest is the request type for the
// DeleteTable API operation.
type DeleteTableRequest struct {
	*aws.Request
	Input *DeleteTableInput
	Copy  func(*DeleteTableInput) DeleteTableRequest
}

// Send marshals and sends the DeleteTable API request.
func (r DeleteTableRequest) Send(ctx context.Context) (*DeleteTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTableResponse{
		DeleteTableOutput: r.Request.Data.(*DeleteTableOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTableResponse is the response type for the
// DeleteTable API operation.
type DeleteTableResponse struct {
	*DeleteTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTable request.
func (r *DeleteTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
