// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package globalacceleratoriface provides an interface to enable mocking the AWS Global Accelerator service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package globalacceleratoriface

import (
	"github.com/aws/aws-sdk-go-v2/service/globalaccelerator"
)

// ClientAPI provides an interface to enable mocking the
// globalaccelerator.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Global Accelerator.
//    func myFunc(svc globalacceleratoriface.ClientAPI) bool {
//        // Make svc.AdvertiseByoipCidr request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := globalaccelerator.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        globalacceleratoriface.ClientPI
//    }
//    func (m *mockClientClient) AdvertiseByoipCidr(input *globalaccelerator.AdvertiseByoipCidrInput) (*globalaccelerator.AdvertiseByoipCidrOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AdvertiseByoipCidrRequest(*globalaccelerator.AdvertiseByoipCidrInput) globalaccelerator.AdvertiseByoipCidrRequest

	CreateAcceleratorRequest(*globalaccelerator.CreateAcceleratorInput) globalaccelerator.CreateAcceleratorRequest

	CreateEndpointGroupRequest(*globalaccelerator.CreateEndpointGroupInput) globalaccelerator.CreateEndpointGroupRequest

	CreateListenerRequest(*globalaccelerator.CreateListenerInput) globalaccelerator.CreateListenerRequest

	DeleteAcceleratorRequest(*globalaccelerator.DeleteAcceleratorInput) globalaccelerator.DeleteAcceleratorRequest

	DeleteEndpointGroupRequest(*globalaccelerator.DeleteEndpointGroupInput) globalaccelerator.DeleteEndpointGroupRequest

	DeleteListenerRequest(*globalaccelerator.DeleteListenerInput) globalaccelerator.DeleteListenerRequest

	DeprovisionByoipCidrRequest(*globalaccelerator.DeprovisionByoipCidrInput) globalaccelerator.DeprovisionByoipCidrRequest

	DescribeAcceleratorRequest(*globalaccelerator.DescribeAcceleratorInput) globalaccelerator.DescribeAcceleratorRequest

	DescribeAcceleratorAttributesRequest(*globalaccelerator.DescribeAcceleratorAttributesInput) globalaccelerator.DescribeAcceleratorAttributesRequest

	DescribeEndpointGroupRequest(*globalaccelerator.DescribeEndpointGroupInput) globalaccelerator.DescribeEndpointGroupRequest

	DescribeListenerRequest(*globalaccelerator.DescribeListenerInput) globalaccelerator.DescribeListenerRequest

	ListAcceleratorsRequest(*globalaccelerator.ListAcceleratorsInput) globalaccelerator.ListAcceleratorsRequest

	ListByoipCidrsRequest(*globalaccelerator.ListByoipCidrsInput) globalaccelerator.ListByoipCidrsRequest

	ListEndpointGroupsRequest(*globalaccelerator.ListEndpointGroupsInput) globalaccelerator.ListEndpointGroupsRequest

	ListListenersRequest(*globalaccelerator.ListListenersInput) globalaccelerator.ListListenersRequest

	ListTagsForResourceRequest(*globalaccelerator.ListTagsForResourceInput) globalaccelerator.ListTagsForResourceRequest

	ProvisionByoipCidrRequest(*globalaccelerator.ProvisionByoipCidrInput) globalaccelerator.ProvisionByoipCidrRequest

	TagResourceRequest(*globalaccelerator.TagResourceInput) globalaccelerator.TagResourceRequest

	UntagResourceRequest(*globalaccelerator.UntagResourceInput) globalaccelerator.UntagResourceRequest

	UpdateAcceleratorRequest(*globalaccelerator.UpdateAcceleratorInput) globalaccelerator.UpdateAcceleratorRequest

	UpdateAcceleratorAttributesRequest(*globalaccelerator.UpdateAcceleratorAttributesInput) globalaccelerator.UpdateAcceleratorAttributesRequest

	UpdateEndpointGroupRequest(*globalaccelerator.UpdateEndpointGroupInput) globalaccelerator.UpdateEndpointGroupRequest

	UpdateListenerRequest(*globalaccelerator.UpdateListenerInput) globalaccelerator.UpdateListenerRequest

	WithdrawByoipCidrRequest(*globalaccelerator.WithdrawByoipCidrInput) globalaccelerator.WithdrawByoipCidrRequest
}

var _ ClientAPI = (*globalaccelerator.Client)(nil)
