// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProvisionedCapacityInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the account that owns the vault. You can either specify
	// an AWS account ID or optionally a single '-' (hyphen), in which case Amazon
	// S3 Glacier uses the AWS account ID associated with the credentials used to
	// sign the request. If you use an account ID, don't include any hyphens ('-')
	// in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProvisionedCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedCapacityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProvisionedCapacityInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisionedCapacityInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListProvisionedCapacityOutput struct {
	_ struct{} `type:"structure"`

	// The response body contains the following JSON fields.
	ProvisionedCapacityList []ProvisionedCapacityDescription `type:"list"`
}

// String returns the string representation
func (s ListProvisionedCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisionedCapacityOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProvisionedCapacityList != nil {
		v := s.ProvisionedCapacityList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProvisionedCapacityList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProvisionedCapacity = "ListProvisionedCapacity"

// ListProvisionedCapacityRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation lists the provisioned capacity units for the specified AWS
// account.
//
//    // Example sending a request using ListProvisionedCapacityRequest.
//    req := client.ListProvisionedCapacityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListProvisionedCapacityRequest(input *ListProvisionedCapacityInput) ListProvisionedCapacityRequest {
	op := &aws.Operation{
		Name:       opListProvisionedCapacity,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/provisioned-capacity",
	}

	if input == nil {
		input = &ListProvisionedCapacityInput{}
	}

	req := c.newRequest(op, input, &ListProvisionedCapacityOutput{})

	return ListProvisionedCapacityRequest{Request: req, Input: input, Copy: c.ListProvisionedCapacityRequest}
}

// ListProvisionedCapacityRequest is the request type for the
// ListProvisionedCapacity API operation.
type ListProvisionedCapacityRequest struct {
	*aws.Request
	Input *ListProvisionedCapacityInput
	Copy  func(*ListProvisionedCapacityInput) ListProvisionedCapacityRequest
}

// Send marshals and sends the ListProvisionedCapacity API request.
func (r ListProvisionedCapacityRequest) Send(ctx context.Context) (*ListProvisionedCapacityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProvisionedCapacityResponse{
		ListProvisionedCapacityOutput: r.Request.Data.(*ListProvisionedCapacityOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListProvisionedCapacityResponse is the response type for the
// ListProvisionedCapacity API operation.
type ListProvisionedCapacityResponse struct {
	*ListProvisionedCapacityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProvisionedCapacity request.
func (r *ListProvisionedCapacityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
