// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type UpdateBuildInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a build to update. You can use either the build ID
	// or ARN value.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`

	// A descriptive label that is associated with a build. Build names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Version information that is associated with a build or script. Version strings
	// do not need to be unique.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBuildInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateBuildInput"}

	if s.BuildId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BuildId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type UpdateBuildOutput struct {
	_ struct{} `type:"structure"`

	// The updated build resource.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s UpdateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateBuild = "UpdateBuild"

// UpdateBuildRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Updates metadata in a build resource, including the build name and version.
// To update the metadata, specify the build ID to update and provide the new
// values. If successful, a build object containing the updated metadata is
// returned.
//
// Learn more
//
//  Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// Related operations
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
//    // Example sending a request using UpdateBuildRequest.
//    req := client.UpdateBuildRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *Client) UpdateBuildRequest(input *UpdateBuildInput) UpdateBuildRequest {
	op := &aws.Operation{
		Name:       opUpdateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBuildInput{}
	}

	req := c.newRequest(op, input, &UpdateBuildOutput{})

	return UpdateBuildRequest{Request: req, Input: input, Copy: c.UpdateBuildRequest}
}

// UpdateBuildRequest is the request type for the
// UpdateBuild API operation.
type UpdateBuildRequest struct {
	*aws.Request
	Input *UpdateBuildInput
	Copy  func(*UpdateBuildInput) UpdateBuildRequest
}

// Send marshals and sends the UpdateBuild API request.
func (r UpdateBuildRequest) Send(ctx context.Context) (*UpdateBuildResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateBuildResponse{
		UpdateBuildOutput: r.Request.Data.(*UpdateBuildOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateBuildResponse is the response type for the
// UpdateBuild API operation.
type UpdateBuildResponse struct {
	*UpdateBuildOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateBuild request.
func (r *UpdateBuildResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
