// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DescribeVpcPeeringConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a fleet. You can use either the fleet ID or ARN value.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// Represents the returned data in response to a request action.
type DescribeVpcPeeringConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of VPC peering connection records that match the request.
	VpcPeeringConnections []VpcPeeringConnection `type:"list"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpcPeeringConnections = "DescribeVpcPeeringConnections"

// DescribeVpcPeeringConnectionsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves information on VPC peering connections. Use this operation to get
// peering information for all fleets or for one specific fleet ID.
//
// To retrieve connection information, call this operation from the AWS account
// that is used to manage the Amazon GameLift fleets. Specify a fleet ID or
// leave the parameter empty to retrieve all connection records. If successful,
// the retrieved information includes both active and pending connections. Active
// connections identify the IpV4 CIDR block that the VPC uses to connect.
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
//    // Example sending a request using DescribeVpcPeeringConnectionsRequest.
//    req := client.DescribeVpcPeeringConnectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections
func (c *Client) DescribeVpcPeeringConnectionsRequest(input *DescribeVpcPeeringConnectionsInput) DescribeVpcPeeringConnectionsRequest {
	op := &aws.Operation{
		Name:       opDescribeVpcPeeringConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringConnectionsInput{}
	}

	req := c.newRequest(op, input, &DescribeVpcPeeringConnectionsOutput{})

	return DescribeVpcPeeringConnectionsRequest{Request: req, Input: input, Copy: c.DescribeVpcPeeringConnectionsRequest}
}

// DescribeVpcPeeringConnectionsRequest is the request type for the
// DescribeVpcPeeringConnections API operation.
type DescribeVpcPeeringConnectionsRequest struct {
	*aws.Request
	Input *DescribeVpcPeeringConnectionsInput
	Copy  func(*DescribeVpcPeeringConnectionsInput) DescribeVpcPeeringConnectionsRequest
}

// Send marshals and sends the DescribeVpcPeeringConnections API request.
func (r DescribeVpcPeeringConnectionsRequest) Send(ctx context.Context) (*DescribeVpcPeeringConnectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpcPeeringConnectionsResponse{
		DescribeVpcPeeringConnectionsOutput: r.Request.Data.(*DescribeVpcPeeringConnectionsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVpcPeeringConnectionsResponse is the response type for the
// DescribeVpcPeeringConnections API operation.
type DescribeVpcPeeringConnectionsResponse struct {
	*DescribeVpcPeeringConnectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpcPeeringConnections request.
func (r *DescribeVpcPeeringConnectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
