// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DescribeGameSessionDetailsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for an alias associated with the fleet to retrieve all
	// game sessions for. You can use either the alias ID or ARN value.
	AliasId *string `type:"string"`

	// A unique identifier for a fleet to retrieve all game sessions active on the
	// fleet. You can use either the fleet ID or ARN value.
	FleetId *string `type:"string"`

	// A unique identifier for the game session to retrieve.
	GameSessionId *string `min:"1" type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGameSessionDetailsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type DescribeGameSessionDetailsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects containing game session properties and the protection
	// policy currently in force for each session matching the request.
	GameSessionDetails []GameSessionDetail `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGameSessionDetails = "DescribeGameSessionDetails"

// DescribeGameSessionDetailsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves properties, including the protection policy in force, for one or
// more game sessions. This action can be used in several ways: (1) provide
// a GameSessionId or GameSessionArn to request details for a specific game
// session; (2) provide either a FleetId or an AliasId to request properties
// for all game sessions running on a fleet.
//
// To get game session record(s), specify just one of the following: game session
// ID, fleet ID, or alias ID. You can filter this request by game session status.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a GameSessionDetail object is returned for each session
// matching the request.
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
//
//    // Example sending a request using DescribeGameSessionDetailsRequest.
//    req := client.DescribeGameSessionDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *Client) DescribeGameSessionDetailsRequest(input *DescribeGameSessionDetailsInput) DescribeGameSessionDetailsRequest {
	op := &aws.Operation{
		Name:       opDescribeGameSessionDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionDetailsInput{}
	}

	req := c.newRequest(op, input, &DescribeGameSessionDetailsOutput{})

	return DescribeGameSessionDetailsRequest{Request: req, Input: input, Copy: c.DescribeGameSessionDetailsRequest}
}

// DescribeGameSessionDetailsRequest is the request type for the
// DescribeGameSessionDetails API operation.
type DescribeGameSessionDetailsRequest struct {
	*aws.Request
	Input *DescribeGameSessionDetailsInput
	Copy  func(*DescribeGameSessionDetailsInput) DescribeGameSessionDetailsRequest
}

// Send marshals and sends the DescribeGameSessionDetails API request.
func (r DescribeGameSessionDetailsRequest) Send(ctx context.Context) (*DescribeGameSessionDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGameSessionDetailsResponse{
		DescribeGameSessionDetailsOutput: r.Request.Data.(*DescribeGameSessionDetailsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGameSessionDetailsResponse is the response type for the
// DescribeGameSessionDetails API operation.
type DescribeGameSessionDetailsResponse struct {
	*DescribeGameSessionDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGameSessionDetails request.
func (r *DescribeGameSessionDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
