// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutOutcomeInput struct {
	_ struct{} `type:"structure"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the outcome.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutOutcomeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOutcomeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutOutcomeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutOutcomeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutOutcomeOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutOutcome = "PutOutcome"

// PutOutcomeRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates or updates an outcome.
//
//    // Example sending a request using PutOutcomeRequest.
//    req := client.PutOutcomeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *Client) PutOutcomeRequest(input *PutOutcomeInput) PutOutcomeRequest {
	op := &aws.Operation{
		Name:       opPutOutcome,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOutcomeInput{}
	}

	req := c.newRequest(op, input, &PutOutcomeOutput{})

	return PutOutcomeRequest{Request: req, Input: input, Copy: c.PutOutcomeRequest}
}

// PutOutcomeRequest is the request type for the
// PutOutcome API operation.
type PutOutcomeRequest struct {
	*aws.Request
	Input *PutOutcomeInput
	Copy  func(*PutOutcomeInput) PutOutcomeRequest
}

// Send marshals and sends the PutOutcome API request.
func (r PutOutcomeRequest) Send(ctx context.Context) (*PutOutcomeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutOutcomeResponse{
		PutOutcomeOutput: r.Request.Data.(*PutOutcomeOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutOutcomeResponse is the response type for the
// PutOutcome API operation.
type PutOutcomeResponse struct {
	*PutOutcomeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutOutcome request.
func (r *PutOutcomeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
