// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEventTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEventTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEventTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetEventTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of event types.
	EventTypes []EventType `locationName:"eventTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEventTypesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEventTypes = "GetEventTypes"

// GetEventTypesRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all event types or a specific event type if name is provided. This is
// a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEventTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
//    // Example sending a request using GetEventTypesRequest.
//    req := client.GetEventTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes
func (c *Client) GetEventTypesRequest(input *GetEventTypesInput) GetEventTypesRequest {
	op := &aws.Operation{
		Name:       opGetEventTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEventTypesInput{}
	}

	req := c.newRequest(op, input, &GetEventTypesOutput{})

	return GetEventTypesRequest{Request: req, Input: input, Copy: c.GetEventTypesRequest}
}

// GetEventTypesRequest is the request type for the
// GetEventTypes API operation.
type GetEventTypesRequest struct {
	*aws.Request
	Input *GetEventTypesInput
	Copy  func(*GetEventTypesInput) GetEventTypesRequest
}

// Send marshals and sends the GetEventTypes API request.
func (r GetEventTypesRequest) Send(ctx context.Context) (*GetEventTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEventTypesResponse{
		GetEventTypesOutput: r.Request.Data.(*GetEventTypesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetEventTypesRequestPaginator returns a paginator for GetEventTypes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetEventTypesRequest(input)
//   p := frauddetector.NewGetEventTypesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetEventTypesPaginator(req GetEventTypesRequest) GetEventTypesPaginator {
	return GetEventTypesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetEventTypesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetEventTypesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetEventTypesPaginator struct {
	aws.Pager
}

func (p *GetEventTypesPaginator) CurrentPage() *GetEventTypesOutput {
	return p.Pager.CurrentPage().(*GetEventTypesOutput)
}

// GetEventTypesResponse is the response type for the
// GetEventTypes API operation.
type GetEventTypesResponse struct {
	*GetEventTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEventTypes request.
func (r *GetEventTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
