// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the event source to display.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePartnerEventSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePartnerEventSourceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the event source.
	Arn *string `type:"string"`

	// The name of the event source.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DescribePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePartnerEventSource = "DescribePartnerEventSource"

// DescribePartnerEventSourceRequest returns a request value for making API operation for
// Amazon EventBridge.
//
// An SaaS partner can use this operation to list details about a partner event
// source that they have created. AWS customers do not use this operation. Instead,
// AWS customers can use DescribeEventSource to see details about a partner
// event source that is shared with them.
//
//    // Example sending a request using DescribePartnerEventSourceRequest.
//    req := client.DescribePartnerEventSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribePartnerEventSource
func (c *Client) DescribePartnerEventSourceRequest(input *DescribePartnerEventSourceInput) DescribePartnerEventSourceRequest {
	op := &aws.Operation{
		Name:       opDescribePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePartnerEventSourceInput{}
	}

	req := c.newRequest(op, input, &DescribePartnerEventSourceOutput{})

	return DescribePartnerEventSourceRequest{Request: req, Input: input, Copy: c.DescribePartnerEventSourceRequest}
}

// DescribePartnerEventSourceRequest is the request type for the
// DescribePartnerEventSource API operation.
type DescribePartnerEventSourceRequest struct {
	*aws.Request
	Input *DescribePartnerEventSourceInput
	Copy  func(*DescribePartnerEventSourceInput) DescribePartnerEventSourceRequest
}

// Send marshals and sends the DescribePartnerEventSource API request.
func (r DescribePartnerEventSourceRequest) Send(ctx context.Context) (*DescribePartnerEventSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePartnerEventSourceResponse{
		DescribePartnerEventSourceOutput: r.Request.Data.(*DescribePartnerEventSourceOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePartnerEventSourceResponse is the response type for the
// DescribePartnerEventSource API operation.
type DescribePartnerEventSourceResponse struct {
	*DescribePartnerEventSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePartnerEventSource request.
func (r *DescribePartnerEventSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
