// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteEventBusInput struct {
	_ struct{} `type:"structure"`

	// The name of the event bus to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventBusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventBusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEventBusInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEventBusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventBusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEventBus = "DeleteEventBus"

// DeleteEventBusRequest returns a request value for making API operation for
// Amazon EventBridge.
//
// Deletes the specified custom event bus or partner event bus. All rules associated
// with this event bus need to be deleted. You can't delete your account's default
// event bus.
//
//    // Example sending a request using DeleteEventBusRequest.
//    req := client.DeleteEventBusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEventBus
func (c *Client) DeleteEventBusRequest(input *DeleteEventBusInput) DeleteEventBusRequest {
	op := &aws.Operation{
		Name:       opDeleteEventBus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventBusInput{}
	}

	req := c.newRequest(op, input, &DeleteEventBusOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteEventBusRequest{Request: req, Input: input, Copy: c.DeleteEventBusRequest}
}

// DeleteEventBusRequest is the request type for the
// DeleteEventBus API operation.
type DeleteEventBusRequest struct {
	*aws.Request
	Input *DeleteEventBusInput
	Copy  func(*DeleteEventBusInput) DeleteEventBusRequest
}

// Send marshals and sends the DeleteEventBus API request.
func (r DeleteEventBusRequest) Send(ctx context.Context) (*DeleteEventBusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEventBusResponse{
		DeleteEventBusOutput: r.Request.Data.(*DeleteEventBusOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEventBusResponse is the response type for the
// DeleteEventBus API operation.
type DeleteEventBusResponse struct {
	*DeleteEventBusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEventBus request.
func (r *DeleteEventBusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
