// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for request parameters to ListDomainsForPackage operation.
type ListDomainsForPackageInput struct {
	_ struct{} `type:"structure"`

	// Limits results to a maximum number of domains.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The package for which to list domains.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDomainsForPackageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsForPackageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDomainsForPackageInput"}

	if s.PackageID == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDomainsForPackageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PackageID != nil {
		v := *s.PackageID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "PackageID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for response parameters to ListDomainsForPackage operation.
type ListDomainsForPackageOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []DomainPackageDetails `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDomainsForPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDomainsForPackageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainPackageDetailsList != nil {
		v := s.DomainPackageDetailsList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainPackageDetailsList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListDomainsForPackage = "ListDomainsForPackage"

// ListDomainsForPackageRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Lists all Amazon ES domains associated with the package.
//
//    // Example sending a request using ListDomainsForPackageRequest.
//    req := client.ListDomainsForPackageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListDomainsForPackageRequest(input *ListDomainsForPackageInput) ListDomainsForPackageRequest {
	op := &aws.Operation{
		Name:       opListDomainsForPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/packages/{PackageID}/domains",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsForPackageInput{}
	}

	req := c.newRequest(op, input, &ListDomainsForPackageOutput{})

	return ListDomainsForPackageRequest{Request: req, Input: input, Copy: c.ListDomainsForPackageRequest}
}

// ListDomainsForPackageRequest is the request type for the
// ListDomainsForPackage API operation.
type ListDomainsForPackageRequest struct {
	*aws.Request
	Input *ListDomainsForPackageInput
	Copy  func(*ListDomainsForPackageInput) ListDomainsForPackageRequest
}

// Send marshals and sends the ListDomainsForPackage API request.
func (r ListDomainsForPackageRequest) Send(ctx context.Context) (*ListDomainsForPackageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDomainsForPackageResponse{
		ListDomainsForPackageOutput: r.Request.Data.(*ListDomainsForPackageOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDomainsForPackageRequestPaginator returns a paginator for ListDomainsForPackage.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDomainsForPackageRequest(input)
//   p := elasticsearchservice.NewListDomainsForPackageRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDomainsForPackagePaginator(req ListDomainsForPackageRequest) ListDomainsForPackagePaginator {
	return ListDomainsForPackagePaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDomainsForPackageInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDomainsForPackagePaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDomainsForPackagePaginator struct {
	aws.Pager
}

func (p *ListDomainsForPackagePaginator) CurrentPage() *ListDomainsForPackageOutput {
	return p.Pager.CurrentPage().(*ListDomainsForPackageOutput)
}

// ListDomainsForPackageResponse is the response type for the
// ListDomainsForPackage API operation.
type ListDomainsForPackageResponse struct {
	*ListDomainsForPackageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDomainsForPackage request.
func (r *ListDomainsForPackageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
