// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DeleteOutboundCrossClusterSearchConnection
// operation.
type DeleteOutboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure"`

	// The id of the outbound connection that you want to permanently delete.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOutboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteOutboundCrossClusterSearchConnectionInput"}

	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOutboundCrossClusterSearchConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CrossClusterSearchConnectionId != nil {
		v := *s.CrossClusterSearchConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a DeleteOutboundCrossClusterSearchConnection operation. Contains
// details of deleted outbound connection.
type DeleteOutboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the OutboundCrossClusterSearchConnection of deleted outbound connection.
	CrossClusterSearchConnection *OutboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation
func (s DeleteOutboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOutboundCrossClusterSearchConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CrossClusterSearchConnection != nil {
		v := s.CrossClusterSearchConnection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CrossClusterSearchConnection", v, metadata)
	}
	return nil
}

const opDeleteOutboundCrossClusterSearchConnection = "DeleteOutboundCrossClusterSearchConnection"

// DeleteOutboundCrossClusterSearchConnectionRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Allows the source domain owner to delete an existing outbound cross-cluster
// search connection.
//
//    // Example sending a request using DeleteOutboundCrossClusterSearchConnectionRequest.
//    req := client.DeleteOutboundCrossClusterSearchConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteOutboundCrossClusterSearchConnectionRequest(input *DeleteOutboundCrossClusterSearchConnectionInput) DeleteOutboundCrossClusterSearchConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteOutboundCrossClusterSearchConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteOutboundCrossClusterSearchConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteOutboundCrossClusterSearchConnectionOutput{})

	return DeleteOutboundCrossClusterSearchConnectionRequest{Request: req, Input: input, Copy: c.DeleteOutboundCrossClusterSearchConnectionRequest}
}

// DeleteOutboundCrossClusterSearchConnectionRequest is the request type for the
// DeleteOutboundCrossClusterSearchConnection API operation.
type DeleteOutboundCrossClusterSearchConnectionRequest struct {
	*aws.Request
	Input *DeleteOutboundCrossClusterSearchConnectionInput
	Copy  func(*DeleteOutboundCrossClusterSearchConnectionInput) DeleteOutboundCrossClusterSearchConnectionRequest
}

// Send marshals and sends the DeleteOutboundCrossClusterSearchConnection API request.
func (r DeleteOutboundCrossClusterSearchConnectionRequest) Send(ctx context.Context) (*DeleteOutboundCrossClusterSearchConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteOutboundCrossClusterSearchConnectionResponse{
		DeleteOutboundCrossClusterSearchConnectionOutput: r.Request.Data.(*DeleteOutboundCrossClusterSearchConnectionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteOutboundCrossClusterSearchConnectionResponse is the response type for the
// DeleteOutboundCrossClusterSearchConnection API operation.
type DeleteOutboundCrossClusterSearchConnectionResponse struct {
	*DeleteOutboundCrossClusterSearchConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteOutboundCrossClusterSearchConnection request.
func (r *DeleteOutboundCrossClusterSearchConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
