// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for CreateAppCookieStickinessPolicy.
type CreateAppCookieStickinessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the application cookie used for stickiness.
	//
	// CookieName is a required field
	CookieName *string `type:"string" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy being created. Policy names must consist of alphanumeric
	// characters and dashes (-). This name must be unique within the set of policies
	// for this load balancer.
	//
	// PolicyName is a required field
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAppCookieStickinessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppCookieStickinessPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAppCookieStickinessPolicyInput"}

	if s.CookieName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CookieName"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output for CreateAppCookieStickinessPolicy.
type CreateAppCookieStickinessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAppCookieStickinessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAppCookieStickinessPolicy = "CreateAppCookieStickinessPolicy"

// CreateAppCookieStickinessPolicyRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Generates a stickiness policy with sticky session lifetimes that follow that
// of an application-generated cookie. This policy can be associated only with
// HTTP/HTTPS listeners.
//
// This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
// except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
// follows the lifetime of the application-generated cookie specified in the
// policy configuration. The load balancer only inserts a new stickiness cookie
// when the application response includes a new application cookie.
//
// If the application cookie is explicitly removed or expires, the session stops
// being sticky until a new application cookie is issued.
//
// For more information, see Application-Controlled Session Stickiness (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using CreateAppCookieStickinessPolicyRequest.
//    req := client.CreateAppCookieStickinessPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateAppCookieStickinessPolicy
func (c *Client) CreateAppCookieStickinessPolicyRequest(input *CreateAppCookieStickinessPolicyInput) CreateAppCookieStickinessPolicyRequest {
	op := &aws.Operation{
		Name:       opCreateAppCookieStickinessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppCookieStickinessPolicyInput{}
	}

	req := c.newRequest(op, input, &CreateAppCookieStickinessPolicyOutput{})

	return CreateAppCookieStickinessPolicyRequest{Request: req, Input: input, Copy: c.CreateAppCookieStickinessPolicyRequest}
}

// CreateAppCookieStickinessPolicyRequest is the request type for the
// CreateAppCookieStickinessPolicy API operation.
type CreateAppCookieStickinessPolicyRequest struct {
	*aws.Request
	Input *CreateAppCookieStickinessPolicyInput
	Copy  func(*CreateAppCookieStickinessPolicyInput) CreateAppCookieStickinessPolicyRequest
}

// Send marshals and sends the CreateAppCookieStickinessPolicy API request.
func (r CreateAppCookieStickinessPolicyRequest) Send(ctx context.Context) (*CreateAppCookieStickinessPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAppCookieStickinessPolicyResponse{
		CreateAppCookieStickinessPolicyOutput: r.Request.Data.(*CreateAppCookieStickinessPolicyOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAppCookieStickinessPolicyResponse is the response type for the
// CreateAppCookieStickinessPolicy API operation.
type CreateAppCookieStickinessPolicyResponse struct {
	*CreateAppCookieStickinessPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAppCookieStickinessPolicy request.
func (r *CreateAppCookieStickinessPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
