// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// This parameter causes the modifications in this request and any pending modifications
	// to be applied, asynchronously and as soon as possible. Modifications to Global
	// Replication Groups cannot be requested to be applied in PreferredMaintenceWindow.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// Determines whether a read replica is automatically promoted to read/write
	// primary if the existing primary encounters a failure.
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// A valid cache node type that you want to scale this Global Datastore to.
	CacheNodeType *string `type:"string"`

	// The upgraded version of the cache engine to be run on the clusters in the
	// Global Datastore.
	EngineVersion *string `type:"string"`

	// A description of the Global Datastore
	GlobalReplicationGroupDescription *string `type:"string"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyGlobalReplicationGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyGlobalReplicationGroupInput"}

	if s.ApplyImmediately == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplyImmediately"))
	}

	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyGlobalReplicationGroup = "ModifyGlobalReplicationGroup"

// ModifyGlobalReplicationGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Modifies the settings for a Global Datastore.
//
//    // Example sending a request using ModifyGlobalReplicationGroupRequest.
//    req := client.ModifyGlobalReplicationGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup
func (c *Client) ModifyGlobalReplicationGroupRequest(input *ModifyGlobalReplicationGroupInput) ModifyGlobalReplicationGroupRequest {
	op := &aws.Operation{
		Name:       opModifyGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyGlobalReplicationGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyGlobalReplicationGroupOutput{})

	return ModifyGlobalReplicationGroupRequest{Request: req, Input: input, Copy: c.ModifyGlobalReplicationGroupRequest}
}

// ModifyGlobalReplicationGroupRequest is the request type for the
// ModifyGlobalReplicationGroup API operation.
type ModifyGlobalReplicationGroupRequest struct {
	*aws.Request
	Input *ModifyGlobalReplicationGroupInput
	Copy  func(*ModifyGlobalReplicationGroupInput) ModifyGlobalReplicationGroupRequest
}

// Send marshals and sends the ModifyGlobalReplicationGroup API request.
func (r ModifyGlobalReplicationGroupRequest) Send(ctx context.Context) (*ModifyGlobalReplicationGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyGlobalReplicationGroupResponse{
		ModifyGlobalReplicationGroupOutput: r.Request.Data.(*ModifyGlobalReplicationGroupOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyGlobalReplicationGroupResponse is the response type for the
// ModifyGlobalReplicationGroup API operation.
type ModifyGlobalReplicationGroupResponse struct {
	*ModifyGlobalReplicationGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyGlobalReplicationGroup request.
func (r *ModifyGlobalReplicationGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
