// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateNodegroupVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that is associated with the managed node
	// group to update.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// Force the update if the existing node group's pods are unable to be drained
	// due to a pod disruption budget issue. If an update fails because pods could
	// not be drained, you can force the update after it fails to terminate the
	// old node whether or not any pods are running on the node.
	Force *bool `locationName:"force" type:"boolean"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS-optimized AMI to use for the update. By
	// default, the latest available AMI version for the node group's Kubernetes
	// version is used. For more information, see Amazon EKS-Optimized Linux AMI
	// Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The Kubernetes version to update to. If no version is specified, then the
	// Kubernetes version of the node group does not change. You can specify the
	// Kubernetes version of the cluster to update the node group to the latest
	// AMI version of the cluster's Kubernetes version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s UpdateNodegroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateNodegroupVersionInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.NodegroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodegroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateNodegroupVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Force != nil {
		v := *s.Force

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "force", protocol.BoolValue(v), metadata)
	}
	if s.ReleaseVersion != nil {
		v := *s.ReleaseVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "releaseVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupName != nil {
		v := *s.NodegroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "nodegroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateNodegroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateNodegroupVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Update != nil {
		v := s.Update

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "update", v, metadata)
	}
	return nil
}

const opUpdateNodegroupVersion = "UpdateNodegroupVersion"

// UpdateNodegroupVersionRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Updates the Kubernetes version or AMI version of an Amazon EKS managed node
// group.
//
// You can update to the latest available AMI version of a node group's current
// Kubernetes version by not specifying a Kubernetes version in the request.
// You can update to the latest AMI version of your cluster's current Kubernetes
// version by specifying your cluster's Kubernetes version in the request. For
// more information, see Amazon EKS-Optimized Linux AMI Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
// in the Amazon EKS User Guide.
//
// You cannot roll back a node group to an earlier Kubernetes version or AMI
// version.
//
// When a node in a managed node group is terminated due to a scaling action
// or update, the pods in that node are drained first. Amazon EKS attempts to
// drain the nodes gracefully and will fail if it is unable to do so. You can
// force the update if Amazon EKS is unable to drain the nodes as a result of
// a pod disruption budget issue.
//
//    // Example sending a request using UpdateNodegroupVersionRequest.
//    req := client.UpdateNodegroupVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *Client) UpdateNodegroupVersionRequest(input *UpdateNodegroupVersionInput) UpdateNodegroupVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateNodegroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-version",
	}

	if input == nil {
		input = &UpdateNodegroupVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateNodegroupVersionOutput{})

	return UpdateNodegroupVersionRequest{Request: req, Input: input, Copy: c.UpdateNodegroupVersionRequest}
}

// UpdateNodegroupVersionRequest is the request type for the
// UpdateNodegroupVersion API operation.
type UpdateNodegroupVersionRequest struct {
	*aws.Request
	Input *UpdateNodegroupVersionInput
	Copy  func(*UpdateNodegroupVersionInput) UpdateNodegroupVersionRequest
}

// Send marshals and sends the UpdateNodegroupVersion API request.
func (r UpdateNodegroupVersionRequest) Send(ctx context.Context) (*UpdateNodegroupVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateNodegroupVersionResponse{
		UpdateNodegroupVersionOutput: r.Request.Data.(*UpdateNodegroupVersionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateNodegroupVersionResponse is the response type for the
// UpdateNodegroupVersion API operation.
type UpdateNodegroupVersionResponse struct {
	*UpdateNodegroupVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateNodegroupVersion request.
func (r *UpdateNodegroupVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
