// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchCheckLayerAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The digests of the image layers to check.
	//
	// LayerDigests is a required field
	LayerDigests []string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the image layers
	// to check. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layers to check.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCheckLayerAvailabilityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchCheckLayerAvailabilityInput"}

	if s.LayerDigests == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LayerDigests", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchCheckLayerAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []LayerFailure `locationName:"failures" type:"list"`

	// A list of image layer objects corresponding to the image layer references
	// in the request.
	Layers []Layer `locationName:"layers" type:"list"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchCheckLayerAvailability = "BatchCheckLayerAvailability"

// BatchCheckLayerAvailabilityRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Checks the availability of one or more image layers in a repository.
//
// When an image is pushed to a repository, each image layer is checked to verify
// if it has been uploaded before. If it has been uploaded, then the image layer
// is skipped.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
//    // Example sending a request using BatchCheckLayerAvailabilityRequest.
//    req := client.BatchCheckLayerAvailabilityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability
func (c *Client) BatchCheckLayerAvailabilityRequest(input *BatchCheckLayerAvailabilityInput) BatchCheckLayerAvailabilityRequest {
	op := &aws.Operation{
		Name:       opBatchCheckLayerAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCheckLayerAvailabilityInput{}
	}

	req := c.newRequest(op, input, &BatchCheckLayerAvailabilityOutput{})

	return BatchCheckLayerAvailabilityRequest{Request: req, Input: input, Copy: c.BatchCheckLayerAvailabilityRequest}
}

// BatchCheckLayerAvailabilityRequest is the request type for the
// BatchCheckLayerAvailability API operation.
type BatchCheckLayerAvailabilityRequest struct {
	*aws.Request
	Input *BatchCheckLayerAvailabilityInput
	Copy  func(*BatchCheckLayerAvailabilityInput) BatchCheckLayerAvailabilityRequest
}

// Send marshals and sends the BatchCheckLayerAvailability API request.
func (r BatchCheckLayerAvailabilityRequest) Send(ctx context.Context) (*BatchCheckLayerAvailabilityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchCheckLayerAvailabilityResponse{
		BatchCheckLayerAvailabilityOutput: r.Request.Data.(*BatchCheckLayerAvailabilityOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchCheckLayerAvailabilityResponse is the response type for the
// BatchCheckLayerAvailability API operation.
type BatchCheckLayerAvailabilityResponse struct {
	*BatchCheckLayerAvailabilityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchCheckLayerAvailability request.
func (r *BatchCheckLayerAvailabilityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
