// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RestoreManagedPrefixListVersionInput struct {
	_ struct{} `type:"structure"`

	// The current version number for the prefix list.
	//
	// CurrentVersion is a required field
	CurrentVersion *int64 `type:"long" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the prefix list.
	//
	// PrefixListId is a required field
	PrefixListId *string `type:"string" required:"true"`

	// The version to restore.
	//
	// PreviousVersion is a required field
	PreviousVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s RestoreManagedPrefixListVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreManagedPrefixListVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreManagedPrefixListVersionInput"}

	if s.CurrentVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentVersion"))
	}

	if s.PrefixListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrefixListId"))
	}

	if s.PreviousVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("PreviousVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestoreManagedPrefixListVersionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the prefix list.
	PrefixList *ManagedPrefixList `locationName:"prefixList" type:"structure"`
}

// String returns the string representation
func (s RestoreManagedPrefixListVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreManagedPrefixListVersion = "RestoreManagedPrefixListVersion"

// RestoreManagedPrefixListVersionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Restores the entries from a previous version of a managed prefix list to
// a new version of the prefix list.
//
//    // Example sending a request using RestoreManagedPrefixListVersionRequest.
//    req := client.RestoreManagedPrefixListVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RestoreManagedPrefixListVersion
func (c *Client) RestoreManagedPrefixListVersionRequest(input *RestoreManagedPrefixListVersionInput) RestoreManagedPrefixListVersionRequest {
	op := &aws.Operation{
		Name:       opRestoreManagedPrefixListVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreManagedPrefixListVersionInput{}
	}

	req := c.newRequest(op, input, &RestoreManagedPrefixListVersionOutput{})

	return RestoreManagedPrefixListVersionRequest{Request: req, Input: input, Copy: c.RestoreManagedPrefixListVersionRequest}
}

// RestoreManagedPrefixListVersionRequest is the request type for the
// RestoreManagedPrefixListVersion API operation.
type RestoreManagedPrefixListVersionRequest struct {
	*aws.Request
	Input *RestoreManagedPrefixListVersionInput
	Copy  func(*RestoreManagedPrefixListVersionInput) RestoreManagedPrefixListVersionRequest
}

// Send marshals and sends the RestoreManagedPrefixListVersion API request.
func (r RestoreManagedPrefixListVersionRequest) Send(ctx context.Context) (*RestoreManagedPrefixListVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreManagedPrefixListVersionResponse{
		RestoreManagedPrefixListVersionOutput: r.Request.Data.(*RestoreManagedPrefixListVersionOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreManagedPrefixListVersionResponse is the response type for the
// RestoreManagedPrefixListVersion API operation.
type RestoreManagedPrefixListVersionResponse struct {
	*RestoreManagedPrefixListVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreManagedPrefixListVersion request.
func (r *RestoreManagedPrefixListVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
