// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetLaunchTemplateDataInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetLaunchTemplateDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchTemplateDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLaunchTemplateDataInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetLaunchTemplateDataOutput struct {
	_ struct{} `type:"structure"`

	// The instance data.
	LaunchTemplateData *ResponseLaunchTemplateData `locationName:"launchTemplateData" type:"structure"`
}

// String returns the string representation
func (s GetLaunchTemplateDataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLaunchTemplateData = "GetLaunchTemplateData"

// GetLaunchTemplateDataRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Retrieves the configuration data of the specified instance. You can use this
// data to create a launch template.
//
// This action calls on other describe actions to get instance information.
// Depending on your instance configuration, you may need to allow the following
// actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications,
// DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or,
// you can allow describe* depending on your instance requirements.
//
//    // Example sending a request using GetLaunchTemplateDataRequest.
//    req := client.GetLaunchTemplateDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetLaunchTemplateData
func (c *Client) GetLaunchTemplateDataRequest(input *GetLaunchTemplateDataInput) GetLaunchTemplateDataRequest {
	op := &aws.Operation{
		Name:       opGetLaunchTemplateData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLaunchTemplateDataInput{}
	}

	req := c.newRequest(op, input, &GetLaunchTemplateDataOutput{})

	return GetLaunchTemplateDataRequest{Request: req, Input: input, Copy: c.GetLaunchTemplateDataRequest}
}

// GetLaunchTemplateDataRequest is the request type for the
// GetLaunchTemplateData API operation.
type GetLaunchTemplateDataRequest struct {
	*aws.Request
	Input *GetLaunchTemplateDataInput
	Copy  func(*GetLaunchTemplateDataInput) GetLaunchTemplateDataRequest
}

// Send marshals and sends the GetLaunchTemplateData API request.
func (r GetLaunchTemplateDataRequest) Send(ctx context.Context) (*GetLaunchTemplateDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLaunchTemplateDataResponse{
		GetLaunchTemplateDataOutput: r.Request.Data.(*GetLaunchTemplateDataOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetLaunchTemplateDataResponse is the response type for the
// GetLaunchTemplateData API operation.
type GetLaunchTemplateDataResponse struct {
	*GetLaunchTemplateDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLaunchTemplateData request.
func (r *GetLaunchTemplateDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
