// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAssociatedIpv6PoolCidrsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the IPv6 address pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssociatedIpv6PoolCidrsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssociatedIpv6PoolCidrsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAssociatedIpv6PoolCidrsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.PoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetAssociatedIpv6PoolCidrsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IPv6 CIDR block associations.
	Ipv6CidrAssociations []Ipv6CidrAssociation `locationName:"ipv6CidrAssociationSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAssociatedIpv6PoolCidrsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAssociatedIpv6PoolCidrs = "GetAssociatedIpv6PoolCidrs"

// GetAssociatedIpv6PoolCidrsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Gets information about the IPv6 CIDR block associations for a specified IPv6
// address pool.
//
//    // Example sending a request using GetAssociatedIpv6PoolCidrsRequest.
//    req := client.GetAssociatedIpv6PoolCidrsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetAssociatedIpv6PoolCidrs
func (c *Client) GetAssociatedIpv6PoolCidrsRequest(input *GetAssociatedIpv6PoolCidrsInput) GetAssociatedIpv6PoolCidrsRequest {
	op := &aws.Operation{
		Name:       opGetAssociatedIpv6PoolCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssociatedIpv6PoolCidrsInput{}
	}

	req := c.newRequest(op, input, &GetAssociatedIpv6PoolCidrsOutput{})

	return GetAssociatedIpv6PoolCidrsRequest{Request: req, Input: input, Copy: c.GetAssociatedIpv6PoolCidrsRequest}
}

// GetAssociatedIpv6PoolCidrsRequest is the request type for the
// GetAssociatedIpv6PoolCidrs API operation.
type GetAssociatedIpv6PoolCidrsRequest struct {
	*aws.Request
	Input *GetAssociatedIpv6PoolCidrsInput
	Copy  func(*GetAssociatedIpv6PoolCidrsInput) GetAssociatedIpv6PoolCidrsRequest
}

// Send marshals and sends the GetAssociatedIpv6PoolCidrs API request.
func (r GetAssociatedIpv6PoolCidrsRequest) Send(ctx context.Context) (*GetAssociatedIpv6PoolCidrsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAssociatedIpv6PoolCidrsResponse{
		GetAssociatedIpv6PoolCidrsOutput: r.Request.Data.(*GetAssociatedIpv6PoolCidrsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetAssociatedIpv6PoolCidrsRequestPaginator returns a paginator for GetAssociatedIpv6PoolCidrs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetAssociatedIpv6PoolCidrsRequest(input)
//   p := ec2.NewGetAssociatedIpv6PoolCidrsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetAssociatedIpv6PoolCidrsPaginator(req GetAssociatedIpv6PoolCidrsRequest) GetAssociatedIpv6PoolCidrsPaginator {
	return GetAssociatedIpv6PoolCidrsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetAssociatedIpv6PoolCidrsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetAssociatedIpv6PoolCidrsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetAssociatedIpv6PoolCidrsPaginator struct {
	aws.Pager
}

func (p *GetAssociatedIpv6PoolCidrsPaginator) CurrentPage() *GetAssociatedIpv6PoolCidrsOutput {
	return p.Pager.CurrentPage().(*GetAssociatedIpv6PoolCidrsOutput)
}

// GetAssociatedIpv6PoolCidrsResponse is the response type for the
// GetAssociatedIpv6PoolCidrs API operation.
type GetAssociatedIpv6PoolCidrsResponse struct {
	*GetAssociatedIpv6PoolCidrsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAssociatedIpv6PoolCidrs request.
func (r *GetAssociatedIpv6PoolCidrsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
