// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeSpotFleetInstances.
type DescribeSpotFleetInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot Fleet request.
	//
	// SpotFleetRequestId is a required field
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSpotFleetInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSpotFleetInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSpotFleetInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.SpotFleetRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpotFleetRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeSpotFleetInstances.
type DescribeSpotFleetInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The running instances. This list is refreshed periodically and might be out
	// of date.
	ActiveInstances []ActiveInstance `locationName:"activeInstanceSet" locationNameList:"item" type:"list"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Spot Fleet request.
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string"`
}

// String returns the string representation
func (s DescribeSpotFleetInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSpotFleetInstances = "DescribeSpotFleetInstances"

// DescribeSpotFleetInstancesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the running instances for the specified Spot Fleet.
//
//    // Example sending a request using DescribeSpotFleetInstancesRequest.
//    req := client.DescribeSpotFleetInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances
func (c *Client) DescribeSpotFleetInstancesRequest(input *DescribeSpotFleetInstancesInput) DescribeSpotFleetInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeSpotFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeSpotFleetInstancesOutput{})

	return DescribeSpotFleetInstancesRequest{Request: req, Input: input, Copy: c.DescribeSpotFleetInstancesRequest}
}

// DescribeSpotFleetInstancesRequest is the request type for the
// DescribeSpotFleetInstances API operation.
type DescribeSpotFleetInstancesRequest struct {
	*aws.Request
	Input *DescribeSpotFleetInstancesInput
	Copy  func(*DescribeSpotFleetInstancesInput) DescribeSpotFleetInstancesRequest
}

// Send marshals and sends the DescribeSpotFleetInstances API request.
func (r DescribeSpotFleetInstancesRequest) Send(ctx context.Context) (*DescribeSpotFleetInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSpotFleetInstancesResponse{
		DescribeSpotFleetInstancesOutput: r.Request.Data.(*DescribeSpotFleetInstancesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSpotFleetInstancesResponse is the response type for the
// DescribeSpotFleetInstances API operation.
type DescribeSpotFleetInstancesResponse struct {
	*DescribeSpotFleetInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSpotFleetInstances request.
func (r *DescribeSpotFleetInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
