// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocalGatewayRouteTablesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * local-gateway-id - The ID of a local gateway.
	//
	//    * local-gateway-route-table-id - The ID of a local gateway route table.
	//
	//    * outpost-arn - The Amazon Resource Name (ARN) of the Outpost.
	//
	//    * state - The state of the local gateway route table.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The IDs of the local gateway route tables.
	LocalGatewayRouteTableIds []string `locationName:"LocalGatewayRouteTableId" locationNameList:"item" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTablesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocalGatewayRouteTablesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocalGatewayRouteTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLocalGatewayRouteTablesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the local gateway route tables.
	LocalGatewayRouteTables []LocalGatewayRouteTable `locationName:"localGatewayRouteTableSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTablesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocalGatewayRouteTables = "DescribeLocalGatewayRouteTables"

// DescribeLocalGatewayRouteTablesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more local gateway route tables. By default, all local gateway
// route tables are described. Alternatively, you can filter the results.
//
//    // Example sending a request using DescribeLocalGatewayRouteTablesRequest.
//    req := client.DescribeLocalGatewayRouteTablesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables
func (c *Client) DescribeLocalGatewayRouteTablesRequest(input *DescribeLocalGatewayRouteTablesInput) DescribeLocalGatewayRouteTablesRequest {
	op := &aws.Operation{
		Name:       opDescribeLocalGatewayRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTablesInput{}
	}

	req := c.newRequest(op, input, &DescribeLocalGatewayRouteTablesOutput{})

	return DescribeLocalGatewayRouteTablesRequest{Request: req, Input: input, Copy: c.DescribeLocalGatewayRouteTablesRequest}
}

// DescribeLocalGatewayRouteTablesRequest is the request type for the
// DescribeLocalGatewayRouteTables API operation.
type DescribeLocalGatewayRouteTablesRequest struct {
	*aws.Request
	Input *DescribeLocalGatewayRouteTablesInput
	Copy  func(*DescribeLocalGatewayRouteTablesInput) DescribeLocalGatewayRouteTablesRequest
}

// Send marshals and sends the DescribeLocalGatewayRouteTables API request.
func (r DescribeLocalGatewayRouteTablesRequest) Send(ctx context.Context) (*DescribeLocalGatewayRouteTablesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocalGatewayRouteTablesResponse{
		DescribeLocalGatewayRouteTablesOutput: r.Request.Data.(*DescribeLocalGatewayRouteTablesOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeLocalGatewayRouteTablesRequestPaginator returns a paginator for DescribeLocalGatewayRouteTables.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeLocalGatewayRouteTablesRequest(input)
//   p := ec2.NewDescribeLocalGatewayRouteTablesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeLocalGatewayRouteTablesPaginator(req DescribeLocalGatewayRouteTablesRequest) DescribeLocalGatewayRouteTablesPaginator {
	return DescribeLocalGatewayRouteTablesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeLocalGatewayRouteTablesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeLocalGatewayRouteTablesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeLocalGatewayRouteTablesPaginator struct {
	aws.Pager
}

func (p *DescribeLocalGatewayRouteTablesPaginator) CurrentPage() *DescribeLocalGatewayRouteTablesOutput {
	return p.Pager.CurrentPage().(*DescribeLocalGatewayRouteTablesOutput)
}

// DescribeLocalGatewayRouteTablesResponse is the response type for the
// DescribeLocalGatewayRouteTables API operation.
type DescribeLocalGatewayRouteTablesResponse struct {
	*DescribeLocalGatewayRouteTablesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocalGatewayRouteTables request.
func (r *DescribeLocalGatewayRouteTablesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
