// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateLocalGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR range used for destination matches. Routing decisions are based
	// on the most specific match.
	//
	// DestinationCidrBlock is a required field
	DestinationCidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the local gateway route table.
	//
	// LocalGatewayRouteTableId is a required field
	LocalGatewayRouteTableId *string `type:"string" required:"true"`

	// The ID of the virtual interface group.
	//
	// LocalGatewayVirtualInterfaceGroupId is a required field
	LocalGatewayVirtualInterfaceGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLocalGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocalGatewayRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLocalGatewayRouteInput"}

	if s.DestinationCidrBlock == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCidrBlock"))
	}

	if s.LocalGatewayRouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalGatewayRouteTableId"))
	}

	if s.LocalGatewayVirtualInterfaceGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalGatewayVirtualInterfaceGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateLocalGatewayRouteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the route.
	Route *LocalGatewayRoute `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s CreateLocalGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLocalGatewayRoute = "CreateLocalGatewayRoute"

// CreateLocalGatewayRouteRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a static route for the specified local gateway route table.
//
//    // Example sending a request using CreateLocalGatewayRouteRequest.
//    req := client.CreateLocalGatewayRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute
func (c *Client) CreateLocalGatewayRouteRequest(input *CreateLocalGatewayRouteInput) CreateLocalGatewayRouteRequest {
	op := &aws.Operation{
		Name:       opCreateLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteInput{}
	}

	req := c.newRequest(op, input, &CreateLocalGatewayRouteOutput{})

	return CreateLocalGatewayRouteRequest{Request: req, Input: input, Copy: c.CreateLocalGatewayRouteRequest}
}

// CreateLocalGatewayRouteRequest is the request type for the
// CreateLocalGatewayRoute API operation.
type CreateLocalGatewayRouteRequest struct {
	*aws.Request
	Input *CreateLocalGatewayRouteInput
	Copy  func(*CreateLocalGatewayRouteInput) CreateLocalGatewayRouteRequest
}

// Send marshals and sends the CreateLocalGatewayRoute API request.
func (r CreateLocalGatewayRouteRequest) Send(ctx context.Context) (*CreateLocalGatewayRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLocalGatewayRouteResponse{
		CreateLocalGatewayRouteOutput: r.Request.Data.(*CreateLocalGatewayRouteOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLocalGatewayRouteResponse is the response type for the
// CreateLocalGatewayRoute API operation.
type CreateLocalGatewayRouteResponse struct {
	*CreateLocalGatewayRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLocalGatewayRoute request.
func (r *CreateLocalGatewayRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
