// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for BundleInstance.
type BundleInstanceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance to bundle.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The bucket in which to store the AMI. You can specify a bucket that you already
	// own or a new bucket that Amazon EC2 creates on your behalf. If you specify
	// a bucket that belongs to someone else, Amazon EC2 returns an error.
	//
	// Storage is a required field
	Storage *Storage `type:"structure" required:"true"`
}

// String returns the string representation
func (s BundleInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BundleInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BundleInstanceInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.Storage == nil {
		invalidParams.Add(aws.NewErrParamRequired("Storage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of BundleInstance.
type BundleInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s BundleInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opBundleInstance = "BundleInstance"

// BundleInstanceRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Bundles an Amazon instance store-backed Windows instance.
//
// During bundling, only the root device volume (C:\) is bundled. Data on other
// instance store volumes is not preserved.
//
// This action is not applicable for Linux/Unix instances or Windows instances
// that are backed by Amazon EBS.
//
//    // Example sending a request using BundleInstanceRequest.
//    req := client.BundleInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *Client) BundleInstanceRequest(input *BundleInstanceInput) BundleInstanceRequest {
	op := &aws.Operation{
		Name:       opBundleInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BundleInstanceInput{}
	}

	req := c.newRequest(op, input, &BundleInstanceOutput{})

	return BundleInstanceRequest{Request: req, Input: input, Copy: c.BundleInstanceRequest}
}

// BundleInstanceRequest is the request type for the
// BundleInstance API operation.
type BundleInstanceRequest struct {
	*aws.Request
	Input *BundleInstanceInput
	Copy  func(*BundleInstanceInput) BundleInstanceRequest
}

// Send marshals and sends the BundleInstance API request.
func (r BundleInstanceRequest) Send(ctx context.Context) (*BundleInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BundleInstanceResponse{
		BundleInstanceOutput: r.Request.Data.(*BundleInstanceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BundleInstanceResponse is the response type for the
// BundleInstance API operation.
type BundleInstanceResponse struct {
	*BundleInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BundleInstance request.
func (r *BundleInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
