// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeContinuousBackupsInput struct {
	_ struct{} `type:"structure"`

	// Name of the table for which the customer wants to check the continuous backups
	// and point in time recovery settings.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContinuousBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContinuousBackupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeContinuousBackupsInput"}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeContinuousBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Represents the continuous backups and point in time recovery settings on
	// the table.
	ContinuousBackupsDescription *ContinuousBackupsDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeContinuousBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeContinuousBackups = "DescribeContinuousBackups"

// DescribeContinuousBackupsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Checks the status of continuous backups and point in time recovery on the
// specified table. Continuous backups are ENABLED on all tables at table creation.
// If point in time recovery is enabled, PointInTimeRecoveryStatus will be set
// to ENABLED.
//
// After continuous backups and point in time recovery are enabled, you can
// restore to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.
//
// LatestRestorableDateTime is typically 5 minutes before the current time.
// You can restore your table to any point in time during the last 35 days.
//
// You can call DescribeContinuousBackups at a maximum rate of 10 times per
// second.
//
//    // Example sending a request using DescribeContinuousBackupsRequest.
//    req := client.DescribeContinuousBackupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups
func (c *Client) DescribeContinuousBackupsRequest(input *DescribeContinuousBackupsInput) DescribeContinuousBackupsRequest {
	op := &aws.Operation{
		Name:       opDescribeContinuousBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContinuousBackupsInput{}
	}

	req := c.newRequest(op, input, &DescribeContinuousBackupsOutput{})

	if req.Config.EnableEndpointDiscovery {
		de := discovererDescribeEndpoints{
			Client:        c,
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": &req.Operation.Name,
			},
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(aws.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}

	return DescribeContinuousBackupsRequest{Request: req, Input: input, Copy: c.DescribeContinuousBackupsRequest}
}

// DescribeContinuousBackupsRequest is the request type for the
// DescribeContinuousBackups API operation.
type DescribeContinuousBackupsRequest struct {
	*aws.Request
	Input *DescribeContinuousBackupsInput
	Copy  func(*DescribeContinuousBackupsInput) DescribeContinuousBackupsRequest
}

// Send marshals and sends the DescribeContinuousBackups API request.
func (r DescribeContinuousBackupsRequest) Send(ctx context.Context) (*DescribeContinuousBackupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeContinuousBackupsResponse{
		DescribeContinuousBackupsOutput: r.Request.Data.(*DescribeContinuousBackupsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeContinuousBackupsResponse is the response type for the
// DescribeContinuousBackups API operation.
type DescribeContinuousBackupsResponse struct {
	*DescribeContinuousBackupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeContinuousBackups request.
func (r *DescribeContinuousBackupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
