// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Registers a new event topic.
type RegisterEventTopicInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID that will publish status messages to the SNS topic.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The SNS topic name to which the directory will publish status messages. This
	// SNS topic must be in the same region as the specified Directory ID.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterEventTopicInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterEventTopicInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterEventTopicInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.TopicName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TopicName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a RegisterEventTopic request.
type RegisterEventTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterEventTopicOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterEventTopic = "RegisterEventTopic"

// RegisterEventTopicRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Associates a directory with an SNS topic. This establishes the directory
// as a publisher to the specified SNS topic. You can then receive email or
// text (SMS) messages when the status of your directory changes. You get notified
// if your directory goes from an Active status to an Impaired or Inoperable
// status. You also receive a notification when the directory returns to an
// Active status.
//
//    // Example sending a request using RegisterEventTopicRequest.
//    req := client.RegisterEventTopicRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic
func (c *Client) RegisterEventTopicRequest(input *RegisterEventTopicInput) RegisterEventTopicRequest {
	op := &aws.Operation{
		Name:       opRegisterEventTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterEventTopicInput{}
	}

	req := c.newRequest(op, input, &RegisterEventTopicOutput{})

	return RegisterEventTopicRequest{Request: req, Input: input, Copy: c.RegisterEventTopicRequest}
}

// RegisterEventTopicRequest is the request type for the
// RegisterEventTopic API operation.
type RegisterEventTopicRequest struct {
	*aws.Request
	Input *RegisterEventTopicInput
	Copy  func(*RegisterEventTopicInput) RegisterEventTopicRequest
}

// Send marshals and sends the RegisterEventTopic API request.
func (r RegisterEventTopicRequest) Send(ctx context.Context) (*RegisterEventTopicResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterEventTopicResponse{
		RegisterEventTopicOutput: r.Request.Data.(*RegisterEventTopicOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterEventTopicResponse is the response type for the
// RegisterEventTopic API operation.
type RegisterEventTopicResponse struct {
	*RegisterEventTopicOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterEventTopic request.
func (r *RegisterEventTopicResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
