// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway
	//
	// This parameter is required when you create an association to a transit gateway.
	//
	// For information about how to set the prefixes, see Allowed Prefixes (https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
	// in the AWS Direct Connect User Guide.
	AddAllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"addAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the virtual private gateway or transit gateway.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayAssociationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDirectConnectGatewayAssociationInput"}

	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectConnectGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The association to be created.
	DirectConnectGatewayAssociation *DirectConnectGatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDirectConnectGatewayAssociation = "CreateDirectConnectGatewayAssociation"

// CreateDirectConnectGatewayAssociationRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Creates an association between a Direct Connect gateway and a virtual private
// gateway. The virtual private gateway must be attached to a VPC and must not
// be associated with another Direct Connect gateway.
//
//    // Example sending a request using CreateDirectConnectGatewayAssociationRequest.
//    req := client.CreateDirectConnectGatewayAssociationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation
func (c *Client) CreateDirectConnectGatewayAssociationRequest(input *CreateDirectConnectGatewayAssociationInput) CreateDirectConnectGatewayAssociationRequest {
	op := &aws.Operation{
		Name:       opCreateDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayAssociationInput{}
	}

	req := c.newRequest(op, input, &CreateDirectConnectGatewayAssociationOutput{})

	return CreateDirectConnectGatewayAssociationRequest{Request: req, Input: input, Copy: c.CreateDirectConnectGatewayAssociationRequest}
}

// CreateDirectConnectGatewayAssociationRequest is the request type for the
// CreateDirectConnectGatewayAssociation API operation.
type CreateDirectConnectGatewayAssociationRequest struct {
	*aws.Request
	Input *CreateDirectConnectGatewayAssociationInput
	Copy  func(*CreateDirectConnectGatewayAssociationInput) CreateDirectConnectGatewayAssociationRequest
}

// Send marshals and sends the CreateDirectConnectGatewayAssociation API request.
func (r CreateDirectConnectGatewayAssociationRequest) Send(ctx context.Context) (*CreateDirectConnectGatewayAssociationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDirectConnectGatewayAssociationResponse{
		CreateDirectConnectGatewayAssociationOutput: r.Request.Data.(*CreateDirectConnectGatewayAssociationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDirectConnectGatewayAssociationResponse is the response type for the
// CreateDirectConnectGatewayAssociation API operation.
type CreateDirectConnectGatewayAssociationResponse struct {
	*CreateDirectConnectGatewayAssociationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDirectConnectGatewayAssociation request.
func (r *CreateDirectConnectGatewayAssociationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
