// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A container for account-level settings in AWS Device Farm.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The AWS account number specified in the AccountSettings container.
	AwsAccountNumber *string `locationName:"awsAccountNumber" min:"2" type:"string"`

	// The default number of minutes (at the account level) a test run executes
	// before it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// The maximum number of minutes a test run executes before it times out.
	MaxJobTimeoutMinutes *int64 `locationName:"maxJobTimeoutMinutes" type:"integer"`

	// The maximum number of device slots that the AWS account can purchase. Each
	// maximum is expressed as an offering-id:number pair, where the offering-id
	// represents one of the IDs returned by the ListOfferings command.
	MaxSlots map[string]int64 `locationName:"maxSlots" type:"map"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// Information about an AWS account's usage of free trial device minutes.
	TrialMinutes *TrialMinutes `locationName:"trialMinutes" type:"structure"`

	// Returns the unmetered devices you have purchased or want to purchase.
	UnmeteredDevices map[string]int64 `locationName:"unmeteredDevices" type:"map"`

	// Returns the unmetered remote access devices you have purchased or want to
	// purchase.
	UnmeteredRemoteAccessDevices map[string]int64 `locationName:"unmeteredRemoteAccessDevices" type:"map"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a test. Examples of artifacts include logs and screenshots.
type Artifact struct {
	_ struct{} `type:"structure"`

	// The artifact's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The artifact's file extension.
	Extension *string `locationName:"extension" type:"string"`

	// The artifact's name.
	Name *string `locationName:"name" type:"string"`

	// The artifact's type.
	//
	// Allowed values include the following:
	//
	//    * UNKNOWN
	//
	//    * SCREENSHOT
	//
	//    * DEVICE_LOG
	//
	//    * MESSAGE_LOG
	//
	//    * VIDEO_LOG
	//
	//    * RESULT_LOG
	//
	//    * SERVICE_LOG
	//
	//    * WEBKIT_LOG
	//
	//    * INSTRUMENTATION_OUTPUT
	//
	//    * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android
	//    fuzz test.
	//
	//    * CALABASH_JSON_OUTPUT
	//
	//    * CALABASH_PRETTY_OUTPUT
	//
	//    * CALABASH_STANDARD_OUTPUT
	//
	//    * CALABASH_JAVA_XML_OUTPUT
	//
	//    * AUTOMATION_OUTPUT
	//
	//    * APPIUM_SERVER_OUTPUT
	//
	//    * APPIUM_JAVA_OUTPUT
	//
	//    * APPIUM_JAVA_XML_OUTPUT
	//
	//    * APPIUM_PYTHON_OUTPUT
	//
	//    * APPIUM_PYTHON_XML_OUTPUT
	//
	//    * EXPLORER_EVENT_LOG
	//
	//    * EXPLORER_SUMMARY_LOG
	//
	//    * APPLICATION_CRASH_REPORT
	//
	//    * XCTEST_LOG
	//
	//    * VIDEO
	//
	//    * CUSTOMER_ARTIFACT
	//
	//    * CUSTOMER_ARTIFACT_LOG
	//
	//    * TESTSPEC_OUTPUT
	Type ArtifactType `locationName:"type" type:"string" enum:"true"`

	// The presigned Amazon S3 URL that can be used with a GET request to download
	// the artifact's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// Represents the amount of CPU that an app is using on a physical device. Does
// not represent system-wide CPU usage.
type CPU struct {
	_ struct{} `type:"structure"`

	// The CPU's architecture (for example, x86 or ARM).
	Architecture *string `locationName:"architecture" type:"string"`

	// The clock speed of the device's CPU, expressed in hertz (Hz). For example,
	// a 1.2 GHz CPU is expressed as 1200000000.
	Clock *float64 `locationName:"clock" type:"double"`

	// The CPU's frequency.
	Frequency *string `locationName:"frequency" type:"string"`
}

// String returns the string representation
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// Represents entity counters.
type Counters struct {
	_ struct{} `type:"structure"`

	// The number of errored entities.
	Errored *int64 `locationName:"errored" type:"integer"`

	// The number of failed entities.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of passed entities.
	Passed *int64 `locationName:"passed" type:"integer"`

	// The number of skipped entities.
	Skipped *int64 `locationName:"skipped" type:"integer"`

	// The number of stopped entities.
	Stopped *int64 `locationName:"stopped" type:"integer"`

	// The total number of entities.
	Total *int64 `locationName:"total" type:"integer"`

	// The number of warned entities.
	Warned *int64 `locationName:"warned" type:"integer"`
}

// String returns the string representation
func (s Counters) String() string {
	return awsutil.Prettify(s)
}

// Configuration settings for a remote access session, including billing method.
type CreateRemoteAccessSessionConfiguration struct {
	_ struct{} `type:"structure"`

	// The billing method for the remote access session.
	BillingMethod BillingMethod `locationName:"billingMethod" type:"string" enum:"true"`

	// An array of ARNs included in the VPC endpoint configuration.
	VpceConfigurationArns []string `locationName:"vpceConfigurationArns" type:"list"`
}

// String returns the string representation
func (s CreateRemoteAccessSessionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// A JSON object that specifies the paths where the artifacts generated by the
// customer's tests, on the device or in the test environment, are pulled from.
//
// Specify deviceHostPaths and optionally specify either iosPaths or androidPaths.
//
// For web app tests, you can specify both iosPaths and androidPaths.
type CustomerArtifactPaths struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of paths on the Android device where the artifacts generated
	// by the customer's tests are pulled from.
	AndroidPaths []string `locationName:"androidPaths" type:"list"`

	// Comma-separated list of paths in the test execution environment where the
	// artifacts generated by the customer's tests are pulled from.
	DeviceHostPaths []string `locationName:"deviceHostPaths" type:"list"`

	// Comma-separated list of paths on the iOS device where the artifacts generated
	// by the customer's tests are pulled from.
	IosPaths []string `locationName:"iosPaths" type:"list"`
}

// String returns the string representation
func (s CustomerArtifactPaths) String() string {
	return awsutil.Prettify(s)
}

// Represents a device type that an app is tested against.
type Device struct {
	_ struct{} `type:"structure"`

	// The device's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Indicates how likely a device is available for a test run. Currently available
	// in the ListDevices and GetDevice API methods.
	Availability DeviceAvailability `locationName:"availability" type:"string" enum:"true"`

	// The device's carrier.
	Carrier *string `locationName:"carrier" type:"string"`

	// Information about the device's CPU.
	Cpu *CPU `locationName:"cpu" type:"structure"`

	// The name of the fleet to which this device belongs.
	FleetName *string `locationName:"fleetName" type:"string"`

	// The type of fleet to which this device belongs. Possible values are PRIVATE
	// and PUBLIC.
	FleetType *string `locationName:"fleetType" type:"string"`

	// The device's form factor.
	//
	// Allowed values include:
	//
	//    * PHONE
	//
	//    * TABLET
	FormFactor DeviceFormFactor `locationName:"formFactor" type:"string" enum:"true"`

	// The device's heap size, expressed in bytes.
	HeapSize *int64 `locationName:"heapSize" type:"long"`

	// The device's image name.
	Image *string `locationName:"image" type:"string"`

	// The instances that belong to this device.
	Instances []DeviceInstance `locationName:"instances" type:"list"`

	// The device's manufacturer name.
	Manufacturer *string `locationName:"manufacturer" type:"string"`

	// The device's total memory size, expressed in bytes.
	Memory *int64 `locationName:"memory" type:"long"`

	// The device's model name.
	Model *string `locationName:"model" type:"string"`

	// The device's model ID.
	ModelId *string `locationName:"modelId" type:"string"`

	// The device's display name.
	Name *string `locationName:"name" type:"string"`

	// The device's operating system type.
	Os *string `locationName:"os" type:"string"`

	// The device's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID
	//
	//    * IOS
	Platform DevicePlatform `locationName:"platform" type:"string" enum:"true"`

	// The device's radio.
	Radio *string `locationName:"radio" type:"string"`

	// Specifies whether remote access has been enabled for the specified device.
	RemoteAccessEnabled *bool `locationName:"remoteAccessEnabled" type:"boolean"`

	// This flag is set to true if remote debugging is enabled for the device.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	RemoteDebugEnabled *bool `locationName:"remoteDebugEnabled" type:"boolean"`

	// The resolution of the device.
	Resolution *Resolution `locationName:"resolution" type:"structure"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// Represents a device filter used to select a set of devices to be included
// in a test run. This data structure is passed in as the deviceSelectionConfiguration
// parameter to ScheduleRun. For an example of the JSON request syntax, see
// ScheduleRun.
//
// It is also passed in as the filters parameter to ListDevices. For an example
// of the JSON request syntax, see ListDevices.
type DeviceFilter struct {
	_ struct{} `type:"structure"`

	// The aspect of a device such as platform or model used as the selection criteria
	// in a device filter.
	//
	// The supported operators for each attribute are provided in the following
	// list.
	//
	// ARN
	//
	// The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// PLATFORM
	//
	// The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS
	//
	// OS_VERSION
	//
	// The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUALS, IN, LESS_THAN,
	// LESS_THAN_OR_EQUALS, NOT_IN
	//
	// MODEL
	//
	// The device model (for example, iPad 5th Gen).
	//
	// Supported operators: CONTAINS, EQUALS, IN, NOT_IN
	//
	// AVAILABILITY
	//
	// The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
	// BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR
	//
	// The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS
	//
	// MANUFACTURER
	//
	// The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// REMOTE_ACCESS_ENABLED
	//
	// Whether the device is enabled for remote access. Valid values are TRUE or
	// FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED
	//
	// Whether the device is enabled for remote debugging. Valid values are TRUE
	// or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	// this filter is ignored.
	//
	// INSTANCE_ARN
	//
	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// INSTANCE_LABELS
	//
	// The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// FLEET_TYPE
	//
	// The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	Attribute DeviceFilterAttribute `locationName:"attribute" type:"string" enum:"true"`

	// Specifies how Device Farm compares the filter's attribute to the value. See
	// the attribute descriptions.
	Operator RuleOperator `locationName:"operator" type:"string" enum:"true"`

	// An array of one or more filter values used in a device filter.
	//
	// Operator Values
	//
	//    * The IN and NOT_IN operators can take a values array that has more than
	//    one element.
	//
	//    * The other operators require an array with a single element.
	//
	// Attribute Values
	//
	//    * The PLATFORM attribute can be set to ANDROID or IOS.
	//
	//    * The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE,
	//    BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	//    * The FORM_FACTOR attribute can be set to PHONE or TABLET.
	//
	//    * The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s DeviceFilter) String() string {
	return awsutil.Prettify(s)
}

// Represents the device instance.
type DeviceInstance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device instance.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The ARN of the device.
	DeviceArn *string `locationName:"deviceArn" min:"32" type:"string"`

	// A object that contains information about the instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`

	// An array of strings that describe the device instance.
	Labels []string `locationName:"labels" type:"list"`

	// The status of the device instance. Valid values are listed here.
	Status InstanceStatus `locationName:"status" type:"string" enum:"true"`

	// Unique device identifier for the device instance.
	Udid *string `locationName:"udid" type:"string"`
}

// String returns the string representation
func (s DeviceInstance) String() string {
	return awsutil.Prettify(s)
}

// Represents the total (metered or unmetered) minutes used by the resource
// to run tests. Contains the sum of minutes consumed by all children.
type DeviceMinutes struct {
	_ struct{} `type:"structure"`

	// When specified, represents only the sum of metered minutes used by the resource
	// to run tests.
	Metered *float64 `locationName:"metered" type:"double"`

	// When specified, represents the total minutes used by the resource to run
	// tests.
	Total *float64 `locationName:"total" type:"double"`

	// When specified, represents only the sum of unmetered minutes used by the
	// resource to run tests.
	Unmetered *float64 `locationName:"unmetered" type:"double"`
}

// String returns the string representation
func (s DeviceMinutes) String() string {
	return awsutil.Prettify(s)
}

// Represents a collection of device types.
type DevicePool struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The number of devices that Device Farm can add to your device pool. Device
	// Farm adds devices that are available and meet the criteria that you assign
	// for the rules parameter. Depending on how many devices meet these constraints,
	// your device pool might contain fewer devices than the value for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that
	// you incur by running tests.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`

	// The device pool's name.
	Name *string `locationName:"name" type:"string"`

	// Information about the device pool's rules.
	Rules []Rule `locationName:"rules" type:"list"`

	// The device pool's type.
	//
	// Allowed values include:
	//
	//    * CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//    * PRIVATE: A device pool that is created and managed by the device pool
	//    developer.
	Type DevicePoolType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s DevicePool) String() string {
	return awsutil.Prettify(s)
}

// Represents a device pool compatibility result.
type DevicePoolCompatibilityResult struct {
	_ struct{} `type:"structure"`

	// Whether the result was compatible with the device pool.
	Compatible *bool `locationName:"compatible" type:"boolean"`

	// The device (phone or tablet) to return information about.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the compatibility.
	IncompatibilityMessages []IncompatibilityMessage `locationName:"incompatibilityMessages" type:"list"`
}

// String returns the string representation
func (s DevicePoolCompatibilityResult) String() string {
	return awsutil.Prettify(s)
}

// Represents the device filters used in a test run and the maximum number of
// devices to be included in the run. It is passed in as the deviceSelectionConfiguration
// request parameter in ScheduleRun.
type DeviceSelectionConfiguration struct {
	_ struct{} `type:"structure"`

	// Used to dynamically select a set of devices for a test run. A filter is made
	// up of an attribute, an operator, and one or more values.
	//
	//    * Attribute The aspect of a device such as platform or model used as the
	//    selection criteria in a device filter. Allowed values include: ARN: The
	//    Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//    PLATFORM: The device platform. Valid values are ANDROID or IOS. OS_VERSION:
	//    The operating system version (for example, 10.3.2). MODEL: The device
	//    model (for example, iPad 5th Gen). AVAILABILITY: The current availability
	//    of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
	//    TEMPORARY_NOT_AVAILABLE. FORM_FACTOR: The device form factor. Valid values
	//    are PHONE or TABLET. MANUFACTURER: The device manufacturer (for example,
	//    Apple). REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
	//    access. Valid values are TRUE or FALSE. REMOTE_DEBUG_ENABLED: Whether
	//    the device is enabled for remote debugging. Valid values are TRUE or FALSE.
	//    Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	//    this filter is ignored. INSTANCE_ARN: The Amazon Resource Name (ARN) of
	//    the device instance. INSTANCE_LABELS: The label of the device instance.
	//    FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	//    * Operator The filter operator. The EQUALS operator is available for every
	//    attribute except INSTANCE_LABELS. The CONTAINS operator is available for
	//    the INSTANCE_LABELS and MODEL attributes. The IN and NOT_IN operators
	//    are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
	//    attributes. The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS
	//    operators are also available for the OS_VERSION attribute.
	//
	//    * Values An array of one or more filter values. Operator Values The IN
	//    and NOT_IN operators can take a values array that has more than one element.
	//    The other operators require an array with a single element. Attribute
	//    Values The PLATFORM attribute can be set to ANDROID or IOS. The AVAILABILITY
	//    attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
	//    The FORM_FACTOR attribute can be set to PHONE or TABLET. The FLEET_TYPE
	//    attribute can be set to PUBLIC or PRIVATE.
	//
	// Filters is a required field
	Filters []DeviceFilter `locationName:"filters" type:"list" required:"true"`

	// The maximum number of devices to be included in a test run.
	//
	// MaxDevices is a required field
	MaxDevices *int64 `locationName:"maxDevices" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeviceSelectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceSelectionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeviceSelectionConfiguration"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.MaxDevices == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxDevices"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the run results requested by the device selection configuration
// and how many devices were returned. For an example of the JSON response syntax,
// see ScheduleRun.
type DeviceSelectionResult struct {
	_ struct{} `type:"structure"`

	// The filters in a device selection result.
	Filters []DeviceFilter `locationName:"filters" type:"list"`

	// The number of devices that matched the device filter selection criteria.
	MatchedDevicesCount *int64 `locationName:"matchedDevicesCount" type:"integer"`

	// The maximum number of devices to be selected by a device filter and included
	// in a test run.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`
}

// String returns the string representation
func (s DeviceSelectionResult) String() string {
	return awsutil.Prettify(s)
}

// Represents configuration information about a test run, such as the execution
// timeout (in minutes).
type ExecutionConfiguration struct {
	_ struct{} `type:"structure"`

	// True if account cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AccountsCleanup *bool `locationName:"accountsCleanup" type:"boolean"`

	// True if app package cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AppPackagesCleanup *bool `locationName:"appPackagesCleanup" type:"boolean"`

	// The number of minutes a test run executes before it times out.
	JobTimeoutMinutes *int64 `locationName:"jobTimeoutMinutes" type:"integer"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// Set to true to enable video capture. Otherwise, set to false. The default
	// is true.
	VideoCapture *bool `locationName:"videoCapture" type:"boolean"`
}

// String returns the string representation
func (s ExecutionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Represents information about incompatibility.
type IncompatibilityMessage struct {
	_ struct{} `type:"structure"`

	// A message about the incompatibility.
	Message *string `locationName:"message" type:"string"`

	// The type of incompatibility.
	//
	// Allowed values include:
	//
	//    * ARN
	//
	//    * FORM_FACTOR (for example, phone or tablet)
	//
	//    * MANUFACTURER
	//
	//    * PLATFORM (for example, Android or iOS)
	//
	//    * REMOTE_ACCESS_ENABLED
	//
	//    * APPIUM_VERSION
	Type DeviceAttribute `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s IncompatibilityMessage) String() string {
	return awsutil.Prettify(s)
}

// Represents the instance profile.
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The description of the instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings containing the list of app packages that should not be
	// cleaned up from the device after a test run completes.
	//
	// The list of packages is considered only if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The name of the instance profile.
	Name *string `locationName:"name" type:"string"`

	// When set to true, Device Farm removes app packages after a test run. The
	// default value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// When set to true, Device Farm reboots the instance after a test run. The
	// default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// Represents a device.
type Job struct {
	_ struct{} `type:"structure"`

	// The job's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The job's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the job was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The device (phone or tablet).
	Device *Device `locationName:"device" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the job.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// The ARN of the instance.
	InstanceArn *string `locationName:"instanceArn" min:"32" type:"string"`

	// A message about the job's result.
	Message *string `locationName:"message" type:"string"`

	// The job's name.
	Name *string `locationName:"name" type:"string"`

	// The job's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// The job's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The job's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status ExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The job's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The job's type.
	//
	// Allowed values include the following:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type TestType `locationName:"type" type:"string" enum:"true"`

	// This value is set to true if video capture is enabled. Otherwise, it is set
	// to false.
	VideoCapture *bool `locationName:"videoCapture" type:"boolean"`

	// The endpoint for streaming device video.
	VideoEndpoint *string `locationName:"videoEndpoint" type:"string"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// Represents a latitude and longitude pair, expressed in geographic coordinate
// system degrees (for example, 47.6204, -122.3491).
//
// Elevation is currently not supported.
type Location struct {
	_ struct{} `type:"structure"`

	// The latitude.
	//
	// Latitude is a required field
	Latitude *float64 `locationName:"latitude" type:"double" required:"true"`

	// The longitude.
	//
	// Longitude is a required field
	Longitude *float64 `locationName:"longitude" type:"double" required:"true"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Location"}

	if s.Latitude == nil {
		invalidParams.Add(aws.NewErrParamRequired("Latitude"))
	}

	if s.Longitude == nil {
		invalidParams.Add(aws.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A number that represents the monetary amount for an offering or transaction.
type MonetaryAmount struct {
	_ struct{} `type:"structure"`

	// The numerical amount of an offering or transaction.
	Amount *float64 `locationName:"amount" type:"double"`

	// The currency code of a monetary amount. For example, USD means U.S. dollars.
	CurrencyCode CurrencyCode `locationName:"currencyCode" type:"string" enum:"true"`
}

// String returns the string representation
func (s MonetaryAmount) String() string {
	return awsutil.Prettify(s)
}

// An array of settings that describes characteristics of a network profile.
type NetworkProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network profile.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The description of the network profile.
	Description *string `locationName:"description" type:"string"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	DownlinkBandwidthBits *int64 `locationName:"downlinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	DownlinkDelayMs *int64 `locationName:"downlinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	DownlinkJitterMs *int64 `locationName:"downlinkJitterMs" type:"long"`

	// Proportion of received packets that fail to arrive from 0 to 100 percent.
	DownlinkLossPercent *int64 `locationName:"downlinkLossPercent" type:"integer"`

	// The name of the network profile.
	Name *string `locationName:"name" type:"string"`

	// The type of network profile. Valid values are listed here.
	Type NetworkProfileType `locationName:"type" type:"string" enum:"true"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	UplinkBandwidthBits *int64 `locationName:"uplinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	UplinkDelayMs *int64 `locationName:"uplinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	UplinkJitterMs *int64 `locationName:"uplinkJitterMs" type:"long"`

	// Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
	UplinkLossPercent *int64 `locationName:"uplinkLossPercent" type:"integer"`
}

// String returns the string representation
func (s NetworkProfile) String() string {
	return awsutil.Prettify(s)
}

// Represents the metadata of a device offering.
type Offering struct {
	_ struct{} `type:"structure"`

	// A string that describes the offering.
	Description *string `locationName:"description" type:"string"`

	// The ID that corresponds to a device offering.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The platform of the device (for example, ANDROID or IOS).
	Platform DevicePlatform `locationName:"platform" type:"string" enum:"true"`

	// Specifies whether there are recurring charges for the offering.
	RecurringCharges []RecurringCharge `locationName:"recurringCharges" type:"list"`

	// The type of offering (for example, RECURRING) for a device.
	Type OfferingType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// Represents information about an offering promotion.
type OfferingPromotion struct {
	_ struct{} `type:"structure"`

	// A string that describes the offering promotion.
	Description *string `locationName:"description" type:"string"`

	// The ID of the offering promotion.
	Id *string `locationName:"id" min:"4" type:"string"`
}

// String returns the string representation
func (s OfferingPromotion) String() string {
	return awsutil.Prettify(s)
}

// The status of the offering.
type OfferingStatus struct {
	_ struct{} `type:"structure"`

	// The date on which the offering is effective.
	EffectiveOn *time.Time `locationName:"effectiveOn" type:"timestamp"`

	// Represents the metadata of an offering status.
	Offering *Offering `locationName:"offering" type:"structure"`

	// The number of available devices in the offering.
	Quantity *int64 `locationName:"quantity" type:"integer"`

	// The type specified for the offering status.
	Type OfferingTransactionType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s OfferingStatus) String() string {
	return awsutil.Prettify(s)
}

// Represents the metadata of an offering transaction.
type OfferingTransaction struct {
	_ struct{} `type:"structure"`

	// The cost of an offering transaction.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The date on which an offering transaction was created.
	CreatedOn *time.Time `locationName:"createdOn" type:"timestamp"`

	// The ID that corresponds to a device offering promotion.
	OfferingPromotionId *string `locationName:"offeringPromotionId" min:"4" type:"string"`

	// The status of an offering transaction.
	OfferingStatus *OfferingStatus `locationName:"offeringStatus" type:"structure"`

	// The transaction ID of the offering transaction.
	TransactionId *string `locationName:"transactionId" min:"32" type:"string"`
}

// String returns the string representation
func (s OfferingTransaction) String() string {
	return awsutil.Prettify(s)
}

// Represents a specific warning or failure.
type Problem struct {
	_ struct{} `type:"structure"`

	// Information about the associated device.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the associated job.
	Job *ProblemDetail `locationName:"job" type:"structure"`

	// A message about the problem's result.
	Message *string `locationName:"message" type:"string"`

	// The problem's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// Information about the associated run.
	Run *ProblemDetail `locationName:"run" type:"structure"`

	// Information about the associated suite.
	Suite *ProblemDetail `locationName:"suite" type:"structure"`

	// Information about the associated test.
	Test *ProblemDetail `locationName:"test" type:"structure"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// Information about a problem detail.
type ProblemDetail struct {
	_ struct{} `type:"structure"`

	// The problem detail's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The problem detail's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ProblemDetail) String() string {
	return awsutil.Prettify(s)
}

// Represents an operating-system neutral workspace for running and managing
// tests.
type Project struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The default number of minutes (at the project level) a test run executes
	// before it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// The project's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// Represents the set of radios and their states on a device. Examples of radios
// include Wi-Fi, GPS, Bluetooth, and NFC.
type Radios struct {
	_ struct{} `type:"structure"`

	// True if Bluetooth is enabled at the beginning of the test. Otherwise, false.
	Bluetooth *bool `locationName:"bluetooth" type:"boolean"`

	// True if GPS is enabled at the beginning of the test. Otherwise, false.
	Gps *bool `locationName:"gps" type:"boolean"`

	// True if NFC is enabled at the beginning of the test. Otherwise, false.
	Nfc *bool `locationName:"nfc" type:"boolean"`

	// True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.
	Wifi *bool `locationName:"wifi" type:"boolean"`
}

// String returns the string representation
func (s Radios) String() string {
	return awsutil.Prettify(s)
}

// Specifies whether charges for devices are recurring.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The cost of the recurring charge.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The frequency in which charges recur.
	Frequency RecurringChargeFrequency `locationName:"frequency" type:"string" enum:"true"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// Represents information about the remote access session.
type RemoteAccessSession struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The billing method of the remote access session. Possible values include
	// METERED or UNMETERED. For more information about metered devices, see AWS
	// Device Farm terminology (https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology).
	BillingMethod BillingMethod `locationName:"billingMethod" type:"string" enum:"true"`

	// Unique identifier of your client for the remote access session. Only returned
	// if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	ClientId *string `locationName:"clientId" type:"string"`

	// The date and time the remote access session was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The device (phone or tablet) used in the remote access session.
	Device *Device `locationName:"device" type:"structure"`

	// The number of minutes a device is used in a remote access session (including
	// setup and teardown minutes).
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// Unique device identifier for the remote device. Only returned if remote debugging
	// is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	DeviceUdid *string `locationName:"deviceUdid" type:"string"`

	// The endpoint for the remote access sesssion.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// IP address of the EC2 host where you need to connect to remotely debug devices.
	// Only returned if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	HostAddress *string `locationName:"hostAddress" type:"string"`

	// The ARN of the instance.
	InstanceArn *string `locationName:"instanceArn" min:"32" type:"string"`

	// The interaction mode of the remote access session. Valid values are:
	//
	//    * INTERACTIVE: You can interact with the iOS device by viewing, touching,
	//    and rotating the screen. You cannot run XCUITest framework-based tests
	//    in this mode.
	//
	//    * NO_VIDEO: You are connected to the device, but cannot interact with
	//    it or view the screen. This mode has the fastest test execution speed.
	//    You can run XCUITest framework-based tests in this mode.
	//
	//    * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it.
	//    You can run XCUITest framework-based tests and watch the screen in this
	//    mode.
	InteractionMode InteractionMode `locationName:"interactionMode" type:"string" enum:"true"`

	// A message about the remote access session.
	Message *string `locationName:"message" type:"string"`

	// The name of the remote access session.
	Name *string `locationName:"name" type:"string"`

	// This flag is set to true if remote debugging is enabled for the remote access
	// session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	RemoteDebugEnabled *bool `locationName:"remoteDebugEnabled" type:"boolean"`

	// The ARN for the app to be recorded in the remote access session.
	RemoteRecordAppArn *string `locationName:"remoteRecordAppArn" min:"32" type:"string"`

	// This flag is set to true if remote recording is enabled for the remote access
	// session.
	RemoteRecordEnabled *bool `locationName:"remoteRecordEnabled" type:"boolean"`

	// The result of the remote access session. Can be any of the following:
	//
	//    * PENDING.
	//
	//    * PASSED.
	//
	//    * WARNED.
	//
	//    * FAILED.
	//
	//    * SKIPPED.
	//
	//    * ERRORED.
	//
	//    * STOPPED.
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// The date and time the remote access session was started.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The status of the remote access session. Can be any of the following:
	//
	//    * PENDING.
	//
	//    * PENDING_CONCURRENCY.
	//
	//    * PENDING_DEVICE.
	//
	//    * PROCESSING.
	//
	//    * SCHEDULING.
	//
	//    * PREPARING.
	//
	//    * RUNNING.
	//
	//    * COMPLETED.
	//
	//    * STOPPING.
	Status ExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The date and time the remote access session was stopped.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`
}

// String returns the string representation
func (s RemoteAccessSession) String() string {
	return awsutil.Prettify(s)
}

// Represents the screen resolution of a device in height and width, expressed
// in pixels.
type Resolution struct {
	_ struct{} `type:"structure"`

	// The screen resolution's height, expressed in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The screen resolution's width, expressed in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s Resolution) String() string {
	return awsutil.Prettify(s)
}

// Represents a condition for a device pool.
type Rule struct {
	_ struct{} `type:"structure"`

	// The rule's stringified attribute. For example, specify the value as "\"abc\"".
	//
	// The supported operators for each attribute are provided in the following
	// list.
	//
	// APPIUM_VERSION
	//
	// The Appium version for the test.
	//
	// Supported operators: CONTAINS
	//
	// ARN
	//
	// The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// AVAILABILITY
	//
	// The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
	// BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FLEET_TYPE
	//
	// The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR
	//
	// The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// INSTANCE_ARN
	//
	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: IN, NOT_IN
	//
	// INSTANCE_LABELS
	//
	// The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// MANUFACTURER
	//
	// The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// MODEL
	//
	// The device model, such as Apple iPad Air 2 or Google Pixel.
	//
	// Supported operators: CONTAINS, EQUALS, IN, NOT_IN
	//
	// OS_VERSION
	//
	// The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUALS, IN, LESS_THAN,
	// LESS_THAN_OR_EQUALS, NOT_IN
	//
	// PLATFORM
	//
	// The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// REMOTE_ACCESS_ENABLED
	//
	// Whether the device is enabled for remote access. Valid values are TRUE or
	// FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED
	//
	// Whether the device is enabled for remote debugging. Valid values are TRUE
	// or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	// this filter is ignored.
	Attribute DeviceAttribute `locationName:"attribute" type:"string" enum:"true"`

	// Specifies how Device Farm compares the rule's attribute to the value. For
	// the operators that are supported by each attribute, see the attribute descriptions.
	Operator RuleOperator `locationName:"operator" type:"string" enum:"true"`

	// The rule's value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Represents a test run on a set of devices with a given app package, test
// parameters, and so on.
type Run struct {
	_ struct{} `type:"structure"`

	// An app to upload or that has been uploaded.
	AppUpload *string `locationName:"appUpload" min:"32" type:"string"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	//
	// If you have unmetered device slots, you must set this to unmetered to use
	// them. Otherwise, the run is counted toward metered device minutes.
	BillingMethod BillingMethod `locationName:"billingMethod" type:"string" enum:"true"`

	// The total number of completed jobs.
	CompletedJobs *int64 `locationName:"completedJobs" type:"integer"`

	// The run's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the run was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Output CustomerArtifactPaths object for the test run.
	CustomerArtifactPaths *CustomerArtifactPaths `locationName:"customerArtifactPaths" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the test run.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// The ARN of the device pool for the run.
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string"`

	// The results of a device filter used to select the devices for a test run.
	DeviceSelectionResult *DeviceSelectionResult `locationName:"deviceSelectionResult" type:"structure"`

	// For fuzz tests, this is the number of events, between 1 and 10000, that the
	// UI fuzz test should perform.
	EventCount *int64 `locationName:"eventCount" type:"integer"`

	// The number of minutes the job executes before it times out.
	JobTimeoutMinutes *int64 `locationName:"jobTimeoutMinutes" type:"integer"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// A message about the run's result.
	Message *string `locationName:"message" type:"string"`

	// The run's name.
	Name *string `locationName:"name" type:"string"`

	// The network profile being used for a test run.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`

	// Read-only URL for an object in an S3 bucket where you can get the parsing
	// results of the test package. If the test package doesn't parse, the reason
	// why it doesn't parse appears in the file that this URL points to.
	ParsingResultUrl *string `locationName:"parsingResultUrl" type:"string"`

	// The run's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID
	//
	//    * IOS
	Platform DevicePlatform `locationName:"platform" type:"string" enum:"true"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`

	// The run's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// Supporting field for the result field. Set only if result is SKIPPED. PARSING_FAILED
	// if the result is skipped because of test package parsing failure.
	ResultCode ExecutionResultCode `locationName:"resultCode" type:"string" enum:"true"`

	// For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using
	// the same seed value between tests ensures identical event sequences.
	Seed *int64 `locationName:"seed" type:"integer"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// The run's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The run's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status ExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The run's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The ARN of the YAML-formatted test specification for the run.
	TestSpecArn *string `locationName:"testSpecArn" min:"32" type:"string"`

	// The total number of jobs for the run.
	TotalJobs *int64 `locationName:"totalJobs" type:"integer"`

	// The run's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type TestType `locationName:"type" type:"string" enum:"true"`

	// The Device Farm console URL for the recording of the run.
	WebUrl *string `locationName:"webUrl" type:"string"`
}

// String returns the string representation
func (s Run) String() string {
	return awsutil.Prettify(s)
}

// Represents a sample of performance data.
type Sample struct {
	_ struct{} `type:"structure"`

	// The sample's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The sample's type.
	//
	// Must be one of the following values:
	//
	//    * CPU: A CPU sample type. This is expressed as the app processing CPU
	//    time (including child processes) as reported by process, as a percentage.
	//
	//    * MEMORY: A memory usage sample type. This is expressed as the total proportional
	//    set size of an app process, in kilobytes.
	//
	//    * NATIVE_AVG_DRAWTIME
	//
	//    * NATIVE_FPS
	//
	//    * NATIVE_FRAMES
	//
	//    * NATIVE_MAX_DRAWTIME
	//
	//    * NATIVE_MIN_DRAWTIME
	//
	//    * OPENGL_AVG_DRAWTIME
	//
	//    * OPENGL_FPS
	//
	//    * OPENGL_FRAMES
	//
	//    * OPENGL_MAX_DRAWTIME
	//
	//    * OPENGL_MIN_DRAWTIME
	//
	//    * RX
	//
	//    * RX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    sent, by app process.
	//
	//    * THREADS: A threads sample type. This is expressed as the total number
	//    of threads per app process.
	//
	//    * TX
	//
	//    * TX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    received, by app process.
	Type SampleType `locationName:"type" type:"string" enum:"true"`

	// The presigned Amazon S3 URL that can be used with a GET request to download
	// the sample's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Sample) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings for a run. Includes things like location, radio states,
// auxiliary apps, and network profiles.
type ScheduleRunConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of upload ARNs for app packages to be installed with your app.
	AuxiliaryApps []string `locationName:"auxiliaryApps" type:"list"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	//
	// If you have purchased unmetered device slots, you must set this parameter
	// to unmetered to make use of them. Otherwise, your run counts against your
	// metered time.
	BillingMethod BillingMethod `locationName:"billingMethod" type:"string" enum:"true"`

	// Input CustomerArtifactPaths object for the scheduled run configuration.
	CustomerArtifactPaths *CustomerArtifactPaths `locationName:"customerArtifactPaths" type:"structure"`

	// The ARN of the extra data for the run. The extra data is a .zip file that
	// AWS Device Farm extracts to external data for Android or the app's sandbox
	// for iOS.
	ExtraDataPackageArn *string `locationName:"extraDataPackageArn" min:"32" type:"string"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// Reserved for internal use.
	NetworkProfileArn *string `locationName:"networkProfileArn" min:"32" type:"string"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`

	// An array of ARNs for your VPC endpoint configurations.
	VpceConfigurationArns []string `locationName:"vpceConfigurationArns" type:"list"`
}

// String returns the string representation
func (s ScheduleRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleRunConfiguration"}
	if s.ExtraDataPackageArn != nil && len(*s.ExtraDataPackageArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ExtraDataPackageArn", 32))
	}
	if s.NetworkProfileArn != nil && len(*s.NetworkProfileArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("NetworkProfileArn", 32))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents test settings. This data structure is passed in as the test parameter
// to ScheduleRun. For an example of the JSON request syntax, see ScheduleRun.
type ScheduleRunTest struct {
	_ struct{} `type:"structure"`

	// The test's filter.
	Filter *string `locationName:"filter" type:"string"`

	// The test's parameters, such as test framework parameters and fixture settings.
	// Parameters are represented by name-value pairs of strings.
	//
	// For all tests:
	//
	//    * app_performance_monitoring: Performance monitoring is enabled by default.
	//    Set this parameter to false to disable it.
	//
	// For Calabash tests:
	//
	//    * profile: A cucumber profile (for example, my_profile_name).
	//
	//    * tags: You can limit execution to features or scenarios that have (or
	//    don't have) certain tags (for example, @smoke or @smoke,~@wip).
	//
	// For Appium tests (all types):
	//
	//    * appium_version: The Appium version. Currently supported values are 1.6.5
	//    (and later), latest, and default. latest runs the latest Appium version
	//    supported by Device Farm (1.9.1). For default, Device Farm selects a compatible
	//    version of Appium for the device. The current behavior is to run 1.7.2
	//    on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
	//    This behavior is subject to change.
	//
	// For fuzz tests (Android only):
	//
	//    * event_count: The number of events, between 1 and 10000, that the UI
	//    fuzz test should perform.
	//
	//    * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test
	//    should wait between events.
	//
	//    * seed: A seed to use for randomizing the UI fuzz test. Using the same
	//    seed value between tests ensures identical event sequences.
	//
	// For Explorer tests:
	//
	//    * username: A user name to use if the Explorer encounters a login form.
	//    If not supplied, no user name is inserted.
	//
	//    * password: A password to use if the Explorer encounters a login form.
	//    If not supplied, no password is inserted.
	//
	// For Instrumentation:
	//
	//    * filter: A test filter string. Examples: Running a single test case:
	//    com.android.abc.Test1 Running a single test: com.android.abc.Test1#smoke
	//    Running multiple tests: com.android.abc.Test1,com.android.abc.Test2
	//
	// For XCTest and XCTestUI:
	//
	//    * filter: A test filter string. Examples: Running a single test class:
	//    LoginTests Running a multiple test classes: LoginTests,SmokeTests Running
	//    a single test: LoginTests/testValid Running multiple tests: LoginTests/testValid,LoginTests/testInvalid
	//
	// For UIAutomator:
	//
	//    * filter: A test filter string. Examples: Running a single test case:
	//    com.android.abc.Test1 Running a single test: com.android.abc.Test1#smoke
	//    Running multiple tests: com.android.abc.Test1,com.android.abc.Test2
	Parameters map[string]string `locationName:"parameters" type:"map"`

	// The ARN of the uploaded test to be run.
	TestPackageArn *string `locationName:"testPackageArn" min:"32" type:"string"`

	// The ARN of the YAML-formatted test specification.
	TestSpecArn *string `locationName:"testSpecArn" min:"32" type:"string"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	//
	// Type is a required field
	Type TestType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ScheduleRunTest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunTest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleRunTest"}
	if s.TestPackageArn != nil && len(*s.TestPackageArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("TestPackageArn", 32))
	}
	if s.TestSpecArn != nil && len(*s.TestSpecArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("TestSpecArn", 32))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a collection of one or more tests.
type Suite struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The suite's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the suite was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Represents the total (metered or unmetered) minutes used by the test suite.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the suite's result.
	Message *string `locationName:"message" type:"string"`

	// The suite's name.
	Name *string `locationName:"name" type:"string"`

	// The suite's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// The suite's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The suite's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status ExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The suite's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The suite's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER Only available for Android; an app explorer that traverses
	//    an Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type TestType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Suite) String() string {
	return awsutil.Prettify(s)
}

// The metadata that you apply to a resource to help you categorize and organize
// it. Each tag consists of a key and an optional value, both of which you define.
// Tag keys can have a maximum character length of 128 characters. Tag values
// can have a maximum length of 256 characters.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that makes up a tag. A value acts as
	// a descriptor in a tag category (key).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a condition that is evaluated.
type Test struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The test's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the test was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Represents the total (metered or unmetered) minutes used by the test.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the test's result.
	Message *string `locationName:"message" type:"string"`

	// The test's name.
	Name *string `locationName:"name" type:"string"`

	// The test's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result ExecutionResult `locationName:"result" type:"string" enum:"true"`

	// The test's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The test's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status ExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// The test's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type TestType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Test) String() string {
	return awsutil.Prettify(s)
}

// A Selenium testing project. Projects are used to collect and collate sessions.
type TestGridProject struct {
	_ struct{} `type:"structure"`

	// The ARN for the project.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A human-readable description for the project.
	Description *string `locationName:"description" type:"string"`

	// A human-readable name for the project.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s TestGridProject) String() string {
	return awsutil.Prettify(s)
}

// A TestGridSession is a single instance of a browser launched from the URL
// provided by a call to CreateTestGridUrl.
type TestGridSession struct {
	_ struct{} `type:"structure"`

	// The ARN of the session.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The number of billed minutes that were used for this session.
	BillingMinutes *float64 `locationName:"billingMinutes" type:"double"`

	// The time that the session was started.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The time the session ended.
	Ended *time.Time `locationName:"ended" type:"timestamp"`

	// A JSON object of options and parameters passed to the Selenium WebDriver.
	SeleniumProperties *string `locationName:"seleniumProperties" type:"string"`

	// The state of the session.
	Status TestGridSessionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s TestGridSession) String() string {
	return awsutil.Prettify(s)
}

// An action taken by a TestGridSession browser instance.
type TestGridSessionAction struct {
	_ struct{} `type:"structure"`

	// The action taken by the session.
	Action *string `locationName:"action" type:"string"`

	// The time, in milliseconds, that the action took to complete in the browser.
	Duration *int64 `locationName:"duration" type:"long"`

	// HTTP method that the browser used to make the request.
	RequestMethod *string `locationName:"requestMethod" type:"string"`

	// The time that the session invoked the action.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// HTTP status code returned to the browser when the action was taken.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s TestGridSessionAction) String() string {
	return awsutil.Prettify(s)
}

// Artifacts are video and other files that are produced in the process of running
// a browser in an automated context.
//
// Video elements might be broken up into multiple artifacts as they grow in
// size during creation.
type TestGridSessionArtifact struct {
	_ struct{} `type:"structure"`

	// The file name of the artifact.
	Filename *string `locationName:"filename" type:"string"`

	// The kind of artifact.
	Type TestGridSessionArtifactType `locationName:"type" type:"string" enum:"true"`

	// A semi-stable URL to the content of the object.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s TestGridSessionArtifact) String() string {
	return awsutil.Prettify(s)
}

// Represents information about free trial device minutes for an AWS account.
type TrialMinutes struct {
	_ struct{} `type:"structure"`

	// The number of free trial minutes remaining in the account.
	Remaining *float64 `locationName:"remaining" type:"double"`

	// The total number of free trial minutes that the account started with.
	Total *float64 `locationName:"total" type:"double"`
}

// String returns the string representation
func (s TrialMinutes) String() string {
	return awsutil.Prettify(s)
}

// A collection of one or more problems, grouped by their result.
type UniqueProblem struct {
	_ struct{} `type:"structure"`

	// A message about the unique problems' result.
	Message *string `locationName:"message" type:"string"`

	// Information about the problems.
	Problems []Problem `locationName:"problems" type:"list"`
}

// String returns the string representation
func (s UniqueProblem) String() string {
	return awsutil.Prettify(s)
}

// An app or a set of one or more tests to upload or that have been uploaded.
type Upload struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The upload's category. Allowed values include:
	//
	//    * CURATED: An upload managed by AWS Device Farm.
	//
	//    * PRIVATE: An upload managed by the AWS Device Farm customer.
	Category UploadCategory `locationName:"category" type:"string" enum:"true"`

	// The upload's content type (for example, application/octet-stream).
	ContentType *string `locationName:"contentType" type:"string"`

	// When the upload was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A message about the upload's result.
	Message *string `locationName:"message" type:"string"`

	// The upload's metadata. For example, for Android, this contains information
	// that is parsed from the manifest and is displayed in the AWS Device Farm
	// console after the associated app is uploaded.
	Metadata *string `locationName:"metadata" type:"string"`

	// The upload's file name.
	Name *string `locationName:"name" type:"string"`

	// The upload's status.
	//
	// Must be one of the following values:
	//
	//    * FAILED
	//
	//    * INITIALIZED
	//
	//    * PROCESSING
	//
	//    * SUCCEEDED
	Status UploadStatus `locationName:"status" type:"string" enum:"true"`

	// The upload's type.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP
	//
	//    * IOS_APP
	//
	//    * WEB_APP
	//
	//    * EXTERNAL_DATA
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_NODE_TEST_PACKAGE
	//
	//    * APPIUM_RUBY_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_WEB_NODE_TEST_PACKAGE
	//
	//    * APPIUM_WEB_RUBY_TEST_PACKAGE
	//
	//    * CALABASH_TEST_PACKAGE
	//
	//    * INSTRUMENTATION_TEST_PACKAGE
	//
	//    * UIAUTOMATION_TEST_PACKAGE
	//
	//    * UIAUTOMATOR_TEST_PACKAGE
	//
	//    * XCTEST_TEST_PACKAGE
	//
	//    * XCTEST_UI_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_PYTHON_TEST_SPEC
	//
	//    * APPIUM_NODE_TEST_SPEC
	//
	//    * APPIUM_RUBY_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_WEB_PYTHON_TEST_SPEC
	//
	//    * APPIUM_WEB_NODE_TEST_SPEC
	//
	//    * APPIUM_WEB_RUBY_TEST_SPEC
	//
	//    * INSTRUMENTATION_TEST_SPEC
	//
	//    * XCTEST_UI_TEST_SPEC
	Type UploadType `locationName:"type" type:"string" enum:"true"`

	// The presigned Amazon S3 URL that was used to store a file using a PUT request.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Upload) String() string {
	return awsutil.Prettify(s)
}

// Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.
type VPCEConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The DNS name that maps to the private IP address of the service you want
	// to access.
	ServiceDnsName *string `locationName:"serviceDnsName" type:"string"`

	// An optional description that provides details about your VPC endpoint configuration.
	VpceConfigurationDescription *string `locationName:"vpceConfigurationDescription" type:"string"`

	// The friendly name you give to your VPC endpoint configuration to manage your
	// configurations more easily.
	VpceConfigurationName *string `locationName:"vpceConfigurationName" type:"string"`

	// The name of the VPC endpoint service running in your AWS account that you
	// want Device Farm to test.
	VpceServiceName *string `locationName:"vpceServiceName" type:"string"`
}

// String returns the string representation
func (s VPCEConfiguration) String() string {
	return awsutil.Prettify(s)
}
