// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTestGridSessionActionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of sessions to return per response.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The ARN of the session to retrieve.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTestGridSessionActionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridSessionActionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTestGridSessionActionsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if s.SessionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SessionArn"))
	}
	if s.SessionArn != nil && len(*s.SessionArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTestGridSessionActionsOutput struct {
	_ struct{} `type:"structure"`

	// The action taken by the session.
	Actions []TestGridSessionAction `locationName:"actions" type:"list"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListTestGridSessionActionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTestGridSessionActions = "ListTestGridSessionActions"

// ListTestGridSessionActionsRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns a list of the actions taken in a TestGridSession.
//
//    // Example sending a request using ListTestGridSessionActionsRequest.
//    req := client.ListTestGridSessionActionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions
func (c *Client) ListTestGridSessionActionsRequest(input *ListTestGridSessionActionsInput) ListTestGridSessionActionsRequest {
	op := &aws.Operation{
		Name:       opListTestGridSessionActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridSessionActionsInput{}
	}

	req := c.newRequest(op, input, &ListTestGridSessionActionsOutput{})

	return ListTestGridSessionActionsRequest{Request: req, Input: input, Copy: c.ListTestGridSessionActionsRequest}
}

// ListTestGridSessionActionsRequest is the request type for the
// ListTestGridSessionActions API operation.
type ListTestGridSessionActionsRequest struct {
	*aws.Request
	Input *ListTestGridSessionActionsInput
	Copy  func(*ListTestGridSessionActionsInput) ListTestGridSessionActionsRequest
}

// Send marshals and sends the ListTestGridSessionActions API request.
func (r ListTestGridSessionActionsRequest) Send(ctx context.Context) (*ListTestGridSessionActionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTestGridSessionActionsResponse{
		ListTestGridSessionActionsOutput: r.Request.Data.(*ListTestGridSessionActionsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTestGridSessionActionsRequestPaginator returns a paginator for ListTestGridSessionActions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTestGridSessionActionsRequest(input)
//   p := devicefarm.NewListTestGridSessionActionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTestGridSessionActionsPaginator(req ListTestGridSessionActionsRequest) ListTestGridSessionActionsPaginator {
	return ListTestGridSessionActionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTestGridSessionActionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTestGridSessionActionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTestGridSessionActionsPaginator struct {
	aws.Pager
}

func (p *ListTestGridSessionActionsPaginator) CurrentPage() *ListTestGridSessionActionsOutput {
	return p.Pager.CurrentPage().(*ListTestGridSessionActionsOutput)
}

// ListTestGridSessionActionsResponse is the response type for the
// ListTestGridSessionActions API operation.
type ListTestGridSessionActionsResponse struct {
	*ListTestGridSessionActionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTestGridSessionActions request.
func (r *ListTestGridSessionActionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
