// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile you are requesting
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInstanceProfileInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes a profile that can be applied to one or more private device instances.
//
//    // Example sending a request using DeleteInstanceProfileRequest.
//    req := client.DeleteInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile
func (c *Client) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) DeleteInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteInstanceProfileOutput{})

	return DeleteInstanceProfileRequest{Request: req, Input: input, Copy: c.DeleteInstanceProfileRequest}
}

// DeleteInstanceProfileRequest is the request type for the
// DeleteInstanceProfile API operation.
type DeleteInstanceProfileRequest struct {
	*aws.Request
	Input *DeleteInstanceProfileInput
	Copy  func(*DeleteInstanceProfileInput) DeleteInstanceProfileRequest
}

// Send marshals and sends the DeleteInstanceProfile API request.
func (r DeleteInstanceProfileRequest) Send(ctx context.Context) (*DeleteInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInstanceProfileResponse{
		DeleteInstanceProfileOutput: r.Request.Data.(*DeleteInstanceProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInstanceProfileResponse is the response type for the
// DeleteInstanceProfile API operation.
type DeleteInstanceProfileResponse struct {
	*DeleteInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInstanceProfile request.
func (r *DeleteInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
