// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package detectiveiface provides an interface to enable mocking the Amazon Detective service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package detectiveiface

import (
	"github.com/aws/aws-sdk-go-v2/service/detective"
)

// ClientAPI provides an interface to enable mocking the
// detective.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Detective.
//    func myFunc(svc detectiveiface.ClientAPI) bool {
//        // Make svc.AcceptInvitation request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := detective.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        detectiveiface.ClientPI
//    }
//    func (m *mockClientClient) AcceptInvitation(input *detective.AcceptInvitationInput) (*detective.AcceptInvitationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AcceptInvitationRequest(*detective.AcceptInvitationInput) detective.AcceptInvitationRequest

	CreateGraphRequest(*detective.CreateGraphInput) detective.CreateGraphRequest

	CreateMembersRequest(*detective.CreateMembersInput) detective.CreateMembersRequest

	DeleteGraphRequest(*detective.DeleteGraphInput) detective.DeleteGraphRequest

	DeleteMembersRequest(*detective.DeleteMembersInput) detective.DeleteMembersRequest

	DisassociateMembershipRequest(*detective.DisassociateMembershipInput) detective.DisassociateMembershipRequest

	GetMembersRequest(*detective.GetMembersInput) detective.GetMembersRequest

	ListGraphsRequest(*detective.ListGraphsInput) detective.ListGraphsRequest

	ListInvitationsRequest(*detective.ListInvitationsInput) detective.ListInvitationsRequest

	ListMembersRequest(*detective.ListMembersInput) detective.ListMembersRequest

	RejectInvitationRequest(*detective.RejectInvitationInput) detective.RejectInvitationRequest

	StartMonitoringMemberRequest(*detective.StartMonitoringMemberInput) detective.StartMonitoringMemberRequest
}

var _ ClientAPI = (*detective.Client)(nil)
