// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package dataexchangeiface provides an interface to enable mocking the AWS Data Exchange service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package dataexchangeiface

import (
	"github.com/aws/aws-sdk-go-v2/service/dataexchange"
)

// ClientAPI provides an interface to enable mocking the
// dataexchange.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Data Exchange.
//    func myFunc(svc dataexchangeiface.ClientAPI) bool {
//        // Make svc.CancelJob request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := dataexchange.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        dataexchangeiface.ClientPI
//    }
//    func (m *mockClientClient) CancelJob(input *dataexchange.CancelJobInput) (*dataexchange.CancelJobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CancelJobRequest(*dataexchange.CancelJobInput) dataexchange.CancelJobRequest

	CreateDataSetRequest(*dataexchange.CreateDataSetInput) dataexchange.CreateDataSetRequest

	CreateJobRequest(*dataexchange.CreateJobInput) dataexchange.CreateJobRequest

	CreateRevisionRequest(*dataexchange.CreateRevisionInput) dataexchange.CreateRevisionRequest

	DeleteAssetRequest(*dataexchange.DeleteAssetInput) dataexchange.DeleteAssetRequest

	DeleteDataSetRequest(*dataexchange.DeleteDataSetInput) dataexchange.DeleteDataSetRequest

	DeleteRevisionRequest(*dataexchange.DeleteRevisionInput) dataexchange.DeleteRevisionRequest

	GetAssetRequest(*dataexchange.GetAssetInput) dataexchange.GetAssetRequest

	GetDataSetRequest(*dataexchange.GetDataSetInput) dataexchange.GetDataSetRequest

	GetJobRequest(*dataexchange.GetJobInput) dataexchange.GetJobRequest

	GetRevisionRequest(*dataexchange.GetRevisionInput) dataexchange.GetRevisionRequest

	ListDataSetRevisionsRequest(*dataexchange.ListDataSetRevisionsInput) dataexchange.ListDataSetRevisionsRequest

	ListDataSetsRequest(*dataexchange.ListDataSetsInput) dataexchange.ListDataSetsRequest

	ListJobsRequest(*dataexchange.ListJobsInput) dataexchange.ListJobsRequest

	ListRevisionAssetsRequest(*dataexchange.ListRevisionAssetsInput) dataexchange.ListRevisionAssetsRequest

	ListTagsForResourceRequest(*dataexchange.ListTagsForResourceInput) dataexchange.ListTagsForResourceRequest

	StartJobRequest(*dataexchange.StartJobInput) dataexchange.StartJobRequest

	TagResourceRequest(*dataexchange.TagResourceInput) dataexchange.TagResourceRequest

	UntagResourceRequest(*dataexchange.UntagResourceInput) dataexchange.UntagResourceRequest

	UpdateAssetRequest(*dataexchange.UpdateAssetInput) dataexchange.UpdateAssetRequest

	UpdateDataSetRequest(*dataexchange.UpdateDataSetInput) dataexchange.UpdateDataSetRequest

	UpdateRevisionRequest(*dataexchange.UpdateRevisionInput) dataexchange.UpdateRevisionRequest
}

var _ ClientAPI = (*dataexchange.Client)(nil)
