// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for the DeliverConfigSnapshot action.
type DeliverConfigSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel through which the snapshot is delivered.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `locationName:"deliveryChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeliverConfigSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliverConfigSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeliverConfigSnapshotInput"}

	if s.DeliveryChannelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the DeliverConfigSnapshot action, in JSON format.
type DeliverConfigSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot that is being created.
	ConfigSnapshotId *string `locationName:"configSnapshotId" type:"string"`
}

// String returns the string representation
func (s DeliverConfigSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeliverConfigSnapshot = "DeliverConfigSnapshot"

// DeliverConfigSnapshotRequest returns a request value for making API operation for
// AWS Config.
//
// Schedules delivery of a configuration snapshot to the Amazon S3 bucket in
// the specified delivery channel. After the delivery has started, AWS Config
// sends the following notifications using an Amazon SNS topic that you have
// specified.
//
//    * Notification of the start of the delivery.
//
//    * Notification of the completion of the delivery, if the delivery was
//    successfully completed.
//
//    * Notification of delivery failure, if the delivery failed.
//
//    // Example sending a request using DeliverConfigSnapshotRequest.
//    req := client.DeliverConfigSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *Client) DeliverConfigSnapshotRequest(input *DeliverConfigSnapshotInput) DeliverConfigSnapshotRequest {
	op := &aws.Operation{
		Name:       opDeliverConfigSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeliverConfigSnapshotInput{}
	}

	req := c.newRequest(op, input, &DeliverConfigSnapshotOutput{})

	return DeliverConfigSnapshotRequest{Request: req, Input: input, Copy: c.DeliverConfigSnapshotRequest}
}

// DeliverConfigSnapshotRequest is the request type for the
// DeliverConfigSnapshot API operation.
type DeliverConfigSnapshotRequest struct {
	*aws.Request
	Input *DeliverConfigSnapshotInput
	Copy  func(*DeliverConfigSnapshotInput) DeliverConfigSnapshotRequest
}

// Send marshals and sends the DeliverConfigSnapshot API request.
func (r DeliverConfigSnapshotRequest) Send(ctx context.Context) (*DeliverConfigSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeliverConfigSnapshotResponse{
		DeliverConfigSnapshotOutput: r.Request.Data.(*DeliverConfigSnapshotOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeliverConfigSnapshotResponse is the response type for the
// DeliverConfigSnapshot API operation.
type DeliverConfigSnapshotResponse struct {
	*DeliverConfigSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeliverConfigSnapshot request.
func (r *DeliverConfigSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
