// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the GetCredentialsForIdentity action.
type GetCredentialsForIdentityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the role to be assumed when multiple roles
	// were received in the token from the identity provider. For example, a SAML-based
	// identity provider. This parameter is optional for identity providers that
	// do not support role customization.
	CustomRoleArn *string `min:"20" type:"string"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// The name-value pair will follow the syntax "provider_name": "provider_user_identifier".
	//
	// Logins should not be specified when trying to get credentials for an unauthenticated
	// identity.
	//
	// The Logins parameter is required when using identities associated with external
	// identity providers such as FaceBook. For examples of Logins maps, see the
	// code examples in the External Identity Providers (http://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html)
	// section of the Amazon Cognito Developer Guide.
	Logins map[string]string `type:"map"`
}

// String returns the string representation
func (s GetCredentialsForIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCredentialsForIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCredentialsForIdentityInput"}
	if s.CustomRoleArn != nil && len(*s.CustomRoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomRoleArn", 20))
	}

	if s.IdentityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned in response to a successful GetCredentialsForIdentity operation.
type GetCredentialsForIdentityOutput struct {
	_ struct{} `type:"structure"`

	// Credentials for the provided identity ID.
	Credentials *Credentials `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCredentialsForIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCredentialsForIdentity = "GetCredentialsForIdentity"

// GetCredentialsForIdentityRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Returns credentials for the provided identity ID. Any provided logins will
// be validated against supported login providers. If the token is for cognito-identity.amazonaws.com,
// it will be passed through to AWS Security Token Service with the appropriate
// role for the token.
//
// This is a public API. You do not need any credentials to call this API.
//
//    // Example sending a request using GetCredentialsForIdentityRequest.
//    req := client.GetCredentialsForIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetCredentialsForIdentity
func (c *Client) GetCredentialsForIdentityRequest(input *GetCredentialsForIdentityInput) GetCredentialsForIdentityRequest {
	op := &aws.Operation{
		Name:       opGetCredentialsForIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialsForIdentityInput{}
	}

	req := c.newRequest(op, input, &GetCredentialsForIdentityOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return GetCredentialsForIdentityRequest{Request: req, Input: input, Copy: c.GetCredentialsForIdentityRequest}
}

// GetCredentialsForIdentityRequest is the request type for the
// GetCredentialsForIdentity API operation.
type GetCredentialsForIdentityRequest struct {
	*aws.Request
	Input *GetCredentialsForIdentityInput
	Copy  func(*GetCredentialsForIdentityInput) GetCredentialsForIdentityRequest
}

// Send marshals and sends the GetCredentialsForIdentity API request.
func (r GetCredentialsForIdentityRequest) Send(ctx context.Context) (*GetCredentialsForIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCredentialsForIdentityResponse{
		GetCredentialsForIdentityOutput: r.Request.Data.(*GetCredentialsForIdentityOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCredentialsForIdentityResponse is the response type for the
// GetCredentialsForIdentity API operation.
type GetCredentialsForIdentityResponse struct {
	*GetCredentialsForIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCredentialsForIdentity request.
func (r *GetCredentialsForIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
