// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarconnections

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the connection to be created. The name must be unique in the
	// calling AWS account.
	//
	// ConnectionName is a required field
	ConnectionName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the host associated with the connection
	// to be created.
	HostArn *string `type:"string"`

	// The name of the external provider where your third-party code repository
	// is configured. The valid provider type is Bitbucket.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The key-value pair to use when tagging the resource.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConnectionInput"}

	if s.ConnectionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionName"))
	}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConnectionName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection to be created. The ARN is
	// used as the connection reference when the connection is shared between AWS
	// services.
	//
	// The ARN is never reused if the connection is deleted.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// Specifies the tags applied to the resource.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest returns a request value for making API operation for
// AWS CodeStar connections.
//
// Creates a connection that can then be given to other AWS services like CodePipeline
// so that it can access third-party code repositories. The connection is in
// pending status until the third-party connection handshake is completed from
// the console.
//
//    // Example sending a request using CreateConnectionRequest.
//    req := client.CreateConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateConnection
func (c *Client) CreateConnectionRequest(input *CreateConnectionInput) CreateConnectionRequest {
	op := &aws.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	req := c.newRequest(op, input, &CreateConnectionOutput{})

	return CreateConnectionRequest{Request: req, Input: input, Copy: c.CreateConnectionRequest}
}

// CreateConnectionRequest is the request type for the
// CreateConnection API operation.
type CreateConnectionRequest struct {
	*aws.Request
	Input *CreateConnectionInput
	Copy  func(*CreateConnectionInput) CreateConnectionRequest
}

// Send marshals and sends the CreateConnection API request.
func (r CreateConnectionRequest) Send(ctx context.Context) (*CreateConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConnectionResponse{
		CreateConnectionOutput: r.Request.Data.(*CreateConnectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConnectionResponse is the response type for the
// CreateConnection API operation.
type CreateConnectionResponse struct {
	*CreateConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConnection request.
func (r *CreateConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
