// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRecommendationFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeReview (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
	// object.
	//
	// CodeReviewArn is a required field
	CodeReviewArn *string `location:"uri" locationName:"CodeReviewArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. The default is
	// 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// Used to query the recommendation feedback for a given recommendation.
	RecommendationIds []string `location:"querystring" locationName:"RecommendationIds" min:"1" type:"list"`

	// An AWS user's account ID or Amazon Resource Name (ARN). Use this ID to query
	// the recommendation feedback for a code review from that user.
	//
	// The UserId is an IAM principal that can be specified as an AWS account ID
	// or an Amazon Resource Name (ARN). For more information, see Specifying a
	// Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
	// in the AWS Identity and Access Management User Guide.
	UserIds []string `location:"querystring" locationName:"UserIds" min:"1" type:"list"`
}

// String returns the string representation
func (s ListRecommendationFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationFeedbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRecommendationFeedbackInput"}

	if s.CodeReviewArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeReviewArn"))
	}
	if s.CodeReviewArn != nil && len(*s.CodeReviewArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CodeReviewArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.RecommendationIds != nil && len(s.RecommendationIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecommendationIds", 1))
	}
	if s.UserIds != nil && len(s.UserIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRecommendationFeedbackInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CodeReviewArn != nil {
		v := *s.CodeReviewArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "CodeReviewArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecommendationIds != nil {
		v := s.RecommendationIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "RecommendationIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UserIds != nil {
		v := s.UserIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "UserIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type ListRecommendationFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `min:"1" type:"string"`

	// Recommendation feedback summaries corresponding to the code review ARN.
	RecommendationFeedbackSummaries []RecommendationFeedbackSummary `type:"list"`
}

// String returns the string representation
func (s ListRecommendationFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRecommendationFeedbackOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecommendationFeedbackSummaries != nil {
		v := s.RecommendationFeedbackSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecommendationFeedbackSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRecommendationFeedback = "ListRecommendationFeedback"

// ListRecommendationFeedbackRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Returns a list of RecommendationFeedbackSummary (https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html)
// objects that contain customer recommendation feedback for all CodeGuru Reviewer
// users.
//
//    // Example sending a request using ListRecommendationFeedbackRequest.
//    req := client.ListRecommendationFeedbackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRecommendationFeedback
func (c *Client) ListRecommendationFeedbackRequest(input *ListRecommendationFeedbackInput) ListRecommendationFeedbackRequest {
	op := &aws.Operation{
		Name:       opListRecommendationFeedback,
		HTTPMethod: "GET",
		HTTPPath:   "/feedback/{CodeReviewArn}/RecommendationFeedback",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationFeedbackInput{}
	}

	req := c.newRequest(op, input, &ListRecommendationFeedbackOutput{})

	return ListRecommendationFeedbackRequest{Request: req, Input: input, Copy: c.ListRecommendationFeedbackRequest}
}

// ListRecommendationFeedbackRequest is the request type for the
// ListRecommendationFeedback API operation.
type ListRecommendationFeedbackRequest struct {
	*aws.Request
	Input *ListRecommendationFeedbackInput
	Copy  func(*ListRecommendationFeedbackInput) ListRecommendationFeedbackRequest
}

// Send marshals and sends the ListRecommendationFeedback API request.
func (r ListRecommendationFeedbackRequest) Send(ctx context.Context) (*ListRecommendationFeedbackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRecommendationFeedbackResponse{
		ListRecommendationFeedbackOutput: r.Request.Data.(*ListRecommendationFeedbackOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRecommendationFeedbackRequestPaginator returns a paginator for ListRecommendationFeedback.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRecommendationFeedbackRequest(input)
//   p := codegurureviewer.NewListRecommendationFeedbackRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRecommendationFeedbackPaginator(req ListRecommendationFeedbackRequest) ListRecommendationFeedbackPaginator {
	return ListRecommendationFeedbackPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRecommendationFeedbackInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRecommendationFeedbackPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRecommendationFeedbackPaginator struct {
	aws.Pager
}

func (p *ListRecommendationFeedbackPaginator) CurrentPage() *ListRecommendationFeedbackOutput {
	return p.Pager.CurrentPage().(*ListRecommendationFeedbackOutput)
}

// ListRecommendationFeedbackResponse is the response type for the
// ListRecommendationFeedback API operation.
type ListRecommendationFeedbackResponse struct {
	*ListRecommendationFeedbackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRecommendationFeedback request.
func (r *ListRecommendationFeedbackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
