// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// To add a new repository association, this parameter specifies a unique identifier
	// for the new repository association that helps ensure idempotency.
	//
	// If you use the AWS CLI or one of the AWS SDKs to call this operation, you
	// can leave this parameter empty. The CLI or SDK generates a random UUID for
	// you and includes that in the request. If you don't use the SDK and instead
	// generate a raw HTTP request to the Secrets Manager service endpoint, you
	// must generate a ClientRequestToken yourself for new versions and include
	// that value in the request.
	//
	// You typically interact with this value if you implement your own retry logic
	// and want to ensure that a given repository association is not created twice.
	// We recommend that you generate a UUID-type value to ensure uniqueness within
	// the specified repository association.
	//
	// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation
	// of duplicate repository associations if there are failures and retries.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The repository to associate.
	//
	// Repository is a required field
	Repository *Repository `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateRepositoryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil {
		if err := s.Repository.Validate(); err != nil {
			invalidParams.AddNested("Repository", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateRepositoryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := s.Repository

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Repository", v, metadata)
	}
	return nil
}

type AssociateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateRepositoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RepositoryAssociation != nil {
		v := s.RepositoryAssociation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RepositoryAssociation", v, metadata)
	}
	return nil
}

const opAssociateRepository = "AssociateRepository"

// AssociateRepositoryRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Use to associate an AWS CodeCommit repository or a repostory managed by AWS
// CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
// repository, CodeGuru Reviewer reviews source code changes in the repository's
// pull requests and provides automatic recommendations. You can view recommendations
// using the CodeGuru Reviewer console. For more information, see Recommendations
// in Amazon CodeGuru Reviewer (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html)
// in the Amazon CodeGuru Reviewer User Guide.
//
// If you associate a CodeCommit repository, it must be in the same AWS Region
// and AWS account where its CodeGuru Reviewer code reviews are configured.
//
// Bitbucket and GitHub Enterprise Server repositories are managed by AWS CodeStar
// Connections to connect to CodeGuru Reviewer. For more information, see Connect
// to a repository source provider (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/reviewer-ug/step-one.html#select-repository-source-provider)
// in the Amazon CodeGuru Reviewer User Guide.
//
// You cannot use the CodeGuru Reviewer SDK or the AWS CLI to associate a GitHub
// repository with Amazon CodeGuru Reviewer. To associate a GitHub repository,
// use the console. For more information, see Getting started with CodeGuru
// Reviewer (https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html)
// in the CodeGuru Reviewer User Guide.
//
//    // Example sending a request using AssociateRepositoryRequest.
//    req := client.AssociateRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/AssociateRepository
func (c *Client) AssociateRepositoryRequest(input *AssociateRepositoryInput) AssociateRepositoryRequest {
	op := &aws.Operation{
		Name:       opAssociateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/associations",
	}

	if input == nil {
		input = &AssociateRepositoryInput{}
	}

	req := c.newRequest(op, input, &AssociateRepositoryOutput{})

	return AssociateRepositoryRequest{Request: req, Input: input, Copy: c.AssociateRepositoryRequest}
}

// AssociateRepositoryRequest is the request type for the
// AssociateRepository API operation.
type AssociateRepositoryRequest struct {
	*aws.Request
	Input *AssociateRepositoryInput
	Copy  func(*AssociateRepositoryInput) AssociateRepositoryRequest
}

// Send marshals and sends the AssociateRepository API request.
func (r AssociateRepositoryRequest) Send(ctx context.Context) (*AssociateRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateRepositoryResponse{
		AssociateRepositoryOutput: r.Request.Data.(*AssociateRepositoryOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateRepositoryResponse is the response type for the
// AssociateRepository API operation.
type AssociateRepositoryResponse struct {
	*AssociateRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateRepository request.
func (r *AssociateRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
