// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the RemoveNotificationChannelRequest.
type RemoveNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// The id of the channel that we want to stop receiving notifications.
	//
	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	// The name of the profiling group we want to change notification configuration
	// for.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveNotificationChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveNotificationChannelInput"}

	if s.ChannelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelId"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveNotificationChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the RemoveNotificationChannelResponse.
type RemoveNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The new notification configuration for this profiling group.
	NotificationConfiguration *NotificationConfiguration `locationName:"notificationConfiguration" type:"structure"`
}

// String returns the string representation
func (s RemoveNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveNotificationChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "notificationConfiguration", v, metadata)
	}
	return nil
}

const opRemoveNotificationChannel = "RemoveNotificationChannel"

// RemoveNotificationChannelRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Remove one anomaly notifications channel for a profiling group.
//
//    // Example sending a request using RemoveNotificationChannelRequest.
//    req := client.RemoveNotificationChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemoveNotificationChannel
func (c *Client) RemoveNotificationChannelRequest(input *RemoveNotificationChannelInput) RemoveNotificationChannelRequest {
	op := &aws.Operation{
		Name:       opRemoveNotificationChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/notificationConfiguration/{channelId}",
	}

	if input == nil {
		input = &RemoveNotificationChannelInput{}
	}

	req := c.newRequest(op, input, &RemoveNotificationChannelOutput{})

	return RemoveNotificationChannelRequest{Request: req, Input: input, Copy: c.RemoveNotificationChannelRequest}
}

// RemoveNotificationChannelRequest is the request type for the
// RemoveNotificationChannel API operation.
type RemoveNotificationChannelRequest struct {
	*aws.Request
	Input *RemoveNotificationChannelInput
	Copy  func(*RemoveNotificationChannelInput) RemoveNotificationChannelRequest
}

// Send marshals and sends the RemoveNotificationChannel API request.
func (r RemoveNotificationChannelRequest) Send(ctx context.Context) (*RemoveNotificationChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveNotificationChannelResponse{
		RemoveNotificationChannelOutput: r.Request.Data.(*RemoveNotificationChannelOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveNotificationChannelResponse is the response type for the
// RemoveNotificationChannel API operation.
type RemoveNotificationChannelResponse struct {
	*RemoveNotificationChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveNotificationChannel request.
func (r *RemoveNotificationChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
